<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FristDauer StructType
 * Meta information extracted from the WSDL
 * - documentation: Fristdauer erlaubt die Angabe von Dauern. Entweder als Einzelwert oder als von bis Wert. Zum Beispiel: 3 Tage, 3-4 Wochen
 * @subpackage Structs
 */
class FristDauer extends AbstractStructBase
{
    /**
     * The dauer
     * Meta information extracted from the WSDL
     * - documentation: Dauer der Frist als Ganzzahl. Wenn dauerBis gesetzt, ist dies der Von-Wert.
     * @var int
     */
    public $dauer;
    /**
     * The einheit
     * Meta information extracted from the WSDL
     * - documentation: Einheit der Dauer.
     * @var \StructType\Code_Zeiteinheit
     */
    public $einheit;
    /**
     * The dauerBis
     * Meta information extracted from the WSDL
     * - documentation: Dauer der Frist als Ganzzahl. Es ist hier der Bis-Wert anzugeben.
     * - minOccurs: 0
     * @var int
     */
    public $dauerBis;
    /**
     * The einheitBis
     * Meta information extracted from the WSDL
     * - documentation: Einheit der DauerBis.
     * - minOccurs: 0
     * @var \StructType\Code_Zeiteinheit
     */
    public $einheitBis;
    /**
     * Constructor method for FristDauer
     * @uses FristDauer::setDauer()
     * @uses FristDauer::setEinheit()
     * @uses FristDauer::setDauerBis()
     * @uses FristDauer::setEinheitBis()
     * @param int $dauer
     * @param \StructType\Code_Zeiteinheit $einheit
     * @param int $dauerBis
     * @param \StructType\Code_Zeiteinheit $einheitBis
     */
    public function __construct($dauer = null, \StructType\Code_Zeiteinheit $einheit = null, $dauerBis = null, \StructType\Code_Zeiteinheit $einheitBis = null)
    {
        $this
            ->setDauer($dauer)
            ->setEinheit($einheit)
            ->setDauerBis($dauerBis)
            ->setEinheitBis($einheitBis);
    }
    /**
     * Get dauer value
     * @return int|null
     */
    public function getDauer()
    {
        return $this->dauer;
    }
    /**
     * Set dauer value
     * @param int $dauer
     * @return \StructType\FristDauer
     */
    public function setDauer($dauer = null)
    {
        // validation for constraint: int
        if (!is_null($dauer) && !(is_int($dauer) || ctype_digit($dauer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dauer, true), gettype($dauer)), __LINE__);
        }
        $this->dauer = $dauer;
        return $this;
    }
    /**
     * Get einheit value
     * @return \StructType\Code_Zeiteinheit|null
     */
    public function getEinheit()
    {
        return $this->einheit;
    }
    /**
     * Set einheit value
     * @param \StructType\Code_Zeiteinheit $einheit
     * @return \StructType\FristDauer
     */
    public function setEinheit(\StructType\Code_Zeiteinheit $einheit = null)
    {
        $this->einheit = $einheit;
        return $this;
    }
    /**
     * Get dauerBis value
     * @return int|null
     */
    public function getDauerBis()
    {
        return $this->dauerBis;
    }
    /**
     * Set dauerBis value
     * @param int $dauerBis
     * @return \StructType\FristDauer
     */
    public function setDauerBis($dauerBis = null)
    {
        // validation for constraint: int
        if (!is_null($dauerBis) && !(is_int($dauerBis) || ctype_digit($dauerBis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dauerBis, true), gettype($dauerBis)), __LINE__);
        }
        $this->dauerBis = $dauerBis;
        return $this;
    }
    /**
     * Get einheitBis value
     * @return \StructType\Code_Zeiteinheit|null
     */
    public function getEinheitBis()
    {
        return $this->einheitBis;
    }
    /**
     * Set einheitBis value
     * @param \StructType\Code_Zeiteinheit $einheitBis
     * @return \StructType\FristDauer
     */
    public function setEinheitBis(\StructType\Code_Zeiteinheit $einheitBis = null)
    {
        $this->einheitBis = $einheitBis;
        return $this;
    }
}
