<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FristAuswahl StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp zur Auswahl der Frist (Dauer oder Stichtag).
 * @subpackage Structs
 */
class FristAuswahl extends AbstractStructBase
{
    /**
     * The fristDauer
     * Meta information extracted from the WSDL
     * - documentation: Frist für Dauer (Zeiträume).
     * - choice: fristDauer | fristStichtag
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\FristDauer
     */
    public $fristDauer;
    /**
     * The fristStichtag
     * Meta information extracted from the WSDL
     * - documentation: Frist für Stichtage oder Stichtagintervalle.
     * - choice: fristDauer | fristStichtag
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\FristStichtag
     */
    public $fristStichtag;
    /**
     * Constructor method for FristAuswahl
     * @uses FristAuswahl::setFristDauer()
     * @uses FristAuswahl::setFristStichtag()
     * @param \StructType\FristDauer $fristDauer
     * @param \StructType\FristStichtag $fristStichtag
     */
    public function __construct(\StructType\FristDauer $fristDauer = null, \StructType\FristStichtag $fristStichtag = null)
    {
        $this
            ->setFristDauer($fristDauer)
            ->setFristStichtag($fristStichtag);
    }
    /**
     * Get fristDauer value
     * @return \StructType\FristDauer|null
     */
    public function getFristDauer()
    {
        return isset($this->fristDauer) ? $this->fristDauer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFristDauer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFristDauer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFristDauerForChoiceConstraintsFromSetFristDauer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'fristStichtag',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property fristDauer can\'t be set as the property %s is already set. Only one property must be set among these properties: fristDauer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set fristDauer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FristDauer $fristDauer
     * @return \StructType\FristAuswahl
     */
    public function setFristDauer(\StructType\FristDauer $fristDauer = null)
    {
        // validation for constraint: choice(fristDauer, fristStichtag)
        if ('' !== ($fristDauerChoiceErrorMessage = self::validateFristDauerForChoiceConstraintsFromSetFristDauer($fristDauer))) {
            throw new \InvalidArgumentException($fristDauerChoiceErrorMessage, __LINE__);
        }
        if (is_null($fristDauer) || (is_array($fristDauer) && empty($fristDauer))) {
            unset($this->fristDauer);
        } else {
            $this->fristDauer = $fristDauer;
        }
        return $this;
    }
    /**
     * Get fristStichtag value
     * @return \StructType\FristStichtag|null
     */
    public function getFristStichtag()
    {
        return isset($this->fristStichtag) ? $this->fristStichtag : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFristStichtag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFristStichtag method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFristStichtagForChoiceConstraintsFromSetFristStichtag($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'fristDauer',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property fristStichtag can\'t be set as the property %s is already set. Only one property must be set among these properties: fristStichtag, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set fristStichtag value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FristStichtag $fristStichtag
     * @return \StructType\FristAuswahl
     */
    public function setFristStichtag(\StructType\FristStichtag $fristStichtag = null)
    {
        // validation for constraint: choice(fristDauer, fristStichtag)
        if ('' !== ($fristStichtagChoiceErrorMessage = self::validateFristStichtagForChoiceConstraintsFromSetFristStichtag($fristStichtag))) {
            throw new \InvalidArgumentException($fristStichtagChoiceErrorMessage, __LINE__);
        }
        if (is_null($fristStichtag) || (is_array($fristStichtag) && empty($fristStichtag))) {
            unset($this->fristStichtag);
        } else {
            $this->fristStichtag = $fristStichtag;
        }
        return $this;
    }
}
