<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Formular StructType
 * Meta information extracted from the WSDL
 * - documentation: Formulare bezeichnen standardisierte Dokumente, in denen individuelle Angaben ergänzt werden können.
 * @subpackage Structs
 */
class Formular extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Primäre ID
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung oder Titel des Formulars.
     * - maxOccurs: unbounded
     * @var \StructType\String_Localized[]
     */
    public $bezeichnung;
    /**
     * The kurzbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Kurze prägnante Bezeichnung des Formulars.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $kurzbezeichnung;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Allgemeine Beschreibung des Formulars.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The hinweis
     * Meta information extracted from the WSDL
     * - documentation: Ausfüllhinweise zum Formular.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $hinweis;
    /**
     * The datei
     * Meta information extracted from the WSDL
     * - documentation: Zuordnung der konkreten Formulardateien zum Formular. Eine Mehrfachzuordnung ist möglich, um verschiedene Ausgabeformate des inhaltlich gleichen Formulars zuzuordnen. Es sollten keine inhaltlich unterschiedlichen Formulardateien pro
     * Formular zugeordnet sein.
     * - maxOccurs: unbounded
     * @var \StructType\Formulardatei[]
     */
    public $datei;
    /**
     * The zustaendigkeit
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Zuständigkeiten zum Formular. Definiert, für welche Leistung + Gebiete dieses Formular relevant ist.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zustaendigkeit[]
     */
    public $zustaendigkeit;
    /**
     * The angabeSignatur
     * Meta information extracted from the WSDL
     * - documentation: Angabe zur Notwendigkeit der Signatur des Formulars.
     * - minOccurs: 0
     * @var \StructType\Code_Signatur
     */
    public $angabeSignatur;
    /**
     * The referenzFIMFormularID
     * Meta information extracted from the WSDL
     * - documentation: Optionale Referenz auf das zugehörige Formular(e) des FIM Formularkatalogs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $referenzFIMFormularID;
    /**
     * The herausgeber
     * Meta information extracted from the WSDL
     * - documentation: Optionale Angabe des Herausgebers der Daten.
     * - minOccurs: 0
     * @var \StructType\Herausgeber
     */
    public $herausgeber;
    /**
     * The versionsinformation
     * Meta information extracted from the WSDL
     * - documentation: Informationen zur Versionierung.
     * - minOccurs: 0
     * @var \StructType\Versionsinformation
     */
    public $versionsinformation;
    /**
     * The sprachversion
     * Meta information extracted from the WSDL
     * - documentation: Angabe aller verfügbaren Sprachversionen des Objekts.
     * - maxOccurs: unbounded
     * @var \StructType\Sprachversion[]
     */
    public $sprachversion;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Formular
     * @uses Formular::setId()
     * @uses Formular::setIdSekundaer()
     * @uses Formular::setBezeichnung()
     * @uses Formular::setKurzbezeichnung()
     * @uses Formular::setBeschreibung()
     * @uses Formular::setHinweis()
     * @uses Formular::setDatei()
     * @uses Formular::setZustaendigkeit()
     * @uses Formular::setAngabeSignatur()
     * @uses Formular::setReferenzFIMFormularID()
     * @uses Formular::setHerausgeber()
     * @uses Formular::setVersionsinformation()
     * @uses Formular::setSprachversion()
     * @uses Formular::setGueltigkeit()
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param \StructType\String_Localized[] $bezeichnung
     * @param \StructType\String_Localized[] $kurzbezeichnung
     * @param \StructType\String_Localized[] $beschreibung
     * @param \StructType\String_Localized[] $hinweis
     * @param \StructType\Formulardatei[] $datei
     * @param \StructType\Zustaendigkeit[] $zustaendigkeit
     * @param \StructType\Code_Signatur $angabeSignatur
     * @param \StructType\Identifikator[] $referenzFIMFormularID
     * @param \StructType\Herausgeber $herausgeber
     * @param \StructType\Versionsinformation $versionsinformation
     * @param \StructType\Sprachversion[] $sprachversion
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\Identifikator $id = null, array $idSekundaer = array(), array $bezeichnung = array(), array $kurzbezeichnung = array(), array $beschreibung = array(), array $hinweis = array(), array $datei = array(), array $zustaendigkeit = array(), \StructType\Code_Signatur $angabeSignatur = null, array $referenzFIMFormularID = array(), \StructType\Herausgeber $herausgeber = null, \StructType\Versionsinformation $versionsinformation = null, array $sprachversion = array(), array $gueltigkeit = array())
    {
        $this
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setBezeichnung($bezeichnung)
            ->setKurzbezeichnung($kurzbezeichnung)
            ->setBeschreibung($beschreibung)
            ->setHinweis($hinweis)
            ->setDatei($datei)
            ->setZustaendigkeit($zustaendigkeit)
            ->setAngabeSignatur($angabeSignatur)
            ->setReferenzFIMFormularID($referenzFIMFormularID)
            ->setHerausgeber($herausgeber)
            ->setVersionsinformation($versionsinformation)
            ->setSprachversion($sprachversion)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Formular
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formularIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$formularIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($formularIdSekundaerItem) ? get_class($formularIdSekundaerItem) : sprintf('%s(%s)', gettype($formularIdSekundaerItem), var_export($formularIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Formular
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Formular
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setBezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBezeichnungForArrayConstraintsFromSetBezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formularBezeichnungItem) {
            // validation for constraint: itemType
            if (!$formularBezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($formularBezeichnungItem) ? get_class($formularBezeichnungItem) : sprintf('%s(%s)', gettype($formularBezeichnungItem), var_export($formularBezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $bezeichnung
     * @return \StructType\Formular
     */
    public function setBezeichnung(array $bezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($bezeichnungArrayErrorMessage = self::validateBezeichnungForArrayConstraintsFromSetBezeichnung($bezeichnung))) {
            throw new \InvalidArgumentException($bezeichnungArrayErrorMessage, __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Add item to bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Formular
     */
    public function addToBezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bezeichnung[] = $item;
        return $this;
    }
    /**
     * Get kurzbezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getKurzbezeichnung()
    {
        return $this->kurzbezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setKurzbezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKurzbezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formularKurzbezeichnungItem) {
            // validation for constraint: itemType
            if (!$formularKurzbezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($formularKurzbezeichnungItem) ? get_class($formularKurzbezeichnungItem) : sprintf('%s(%s)', gettype($formularKurzbezeichnungItem), var_export($formularKurzbezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $kurzbezeichnung
     * @return \StructType\Formular
     */
    public function setKurzbezeichnung(array $kurzbezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($kurzbezeichnungArrayErrorMessage = self::validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung($kurzbezeichnung))) {
            throw new \InvalidArgumentException($kurzbezeichnungArrayErrorMessage, __LINE__);
        }
        $this->kurzbezeichnung = $kurzbezeichnung;
        return $this;
    }
    /**
     * Add item to kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Formular
     */
    public function addToKurzbezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kurzbezeichnung[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formularBeschreibungItem) {
            // validation for constraint: itemType
            if (!$formularBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($formularBeschreibungItem) ? get_class($formularBeschreibungItem) : sprintf('%s(%s)', gettype($formularBeschreibungItem), var_export($formularBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Formular
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Formular
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get hinweis value
     * @return \StructType\String_Localized[]|null
     */
    public function getHinweis()
    {
        return $this->hinweis;
    }
    /**
     * This method is responsible for validating the values passed to the setHinweis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHinweis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHinweisForArrayConstraintsFromSetHinweis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formularHinweisItem) {
            // validation for constraint: itemType
            if (!$formularHinweisItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($formularHinweisItem) ? get_class($formularHinweisItem) : sprintf('%s(%s)', gettype($formularHinweisItem), var_export($formularHinweisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hinweis property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hinweis value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $hinweis
     * @return \StructType\Formular
     */
    public function setHinweis(array $hinweis = array())
    {
        // validation for constraint: array
        if ('' !== ($hinweisArrayErrorMessage = self::validateHinweisForArrayConstraintsFromSetHinweis($hinweis))) {
            throw new \InvalidArgumentException($hinweisArrayErrorMessage, __LINE__);
        }
        $this->hinweis = $hinweis;
        return $this;
    }
    /**
     * Add item to hinweis value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Formular
     */
    public function addToHinweis(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The hinweis property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hinweis[] = $item;
        return $this;
    }
    /**
     * Get datei value
     * @return \StructType\Formulardatei[]|null
     */
    public function getDatei()
    {
        return $this->datei;
    }
    /**
     * This method is responsible for validating the values passed to the setDatei method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatei method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateiForArrayConstraintsFromSetDatei(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formularDateiItem) {
            // validation for constraint: itemType
            if (!$formularDateiItem instanceof \StructType\Formulardatei) {
                $invalidValues[] = is_object($formularDateiItem) ? get_class($formularDateiItem) : sprintf('%s(%s)', gettype($formularDateiItem), var_export($formularDateiItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The datei property can only contain items of type \StructType\Formulardatei, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set datei value
     * @throws \InvalidArgumentException
     * @param \StructType\Formulardatei[] $datei
     * @return \StructType\Formular
     */
    public function setDatei(array $datei = array())
    {
        // validation for constraint: array
        if ('' !== ($dateiArrayErrorMessage = self::validateDateiForArrayConstraintsFromSetDatei($datei))) {
            throw new \InvalidArgumentException($dateiArrayErrorMessage, __LINE__);
        }
        $this->datei = $datei;
        return $this;
    }
    /**
     * Add item to datei value
     * @throws \InvalidArgumentException
     * @param \StructType\Formulardatei $item
     * @return \StructType\Formular
     */
    public function addToDatei(\StructType\Formulardatei $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Formulardatei) {
            throw new \InvalidArgumentException(sprintf('The datei property can only contain items of type \StructType\Formulardatei, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->datei[] = $item;
        return $this;
    }
    /**
     * Get zustaendigkeit value
     * @return \StructType\Zustaendigkeit[]|null
     */
    public function getZustaendigkeit()
    {
        return $this->zustaendigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitForArrayConstraintsFromSetZustaendigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formularZustaendigkeitItem) {
            // validation for constraint: itemType
            if (!$formularZustaendigkeitItem instanceof \StructType\Zustaendigkeit) {
                $invalidValues[] = is_object($formularZustaendigkeitItem) ? get_class($formularZustaendigkeitItem) : sprintf('%s(%s)', gettype($formularZustaendigkeitItem), var_export($formularZustaendigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeit property can only contain items of type \StructType\Zustaendigkeit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zustaendigkeit[] $zustaendigkeit
     * @return \StructType\Formular
     */
    public function setZustaendigkeit(array $zustaendigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitArrayErrorMessage = self::validateZustaendigkeitForArrayConstraintsFromSetZustaendigkeit($zustaendigkeit))) {
            throw new \InvalidArgumentException($zustaendigkeitArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeit = $zustaendigkeit;
        return $this;
    }
    /**
     * Add item to zustaendigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zustaendigkeit $item
     * @return \StructType\Formular
     */
    public function addToZustaendigkeit(\StructType\Zustaendigkeit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zustaendigkeit) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeit property can only contain items of type \StructType\Zustaendigkeit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeit[] = $item;
        return $this;
    }
    /**
     * Get angabeSignatur value
     * @return \StructType\Code_Signatur|null
     */
    public function getAngabeSignatur()
    {
        return $this->angabeSignatur;
    }
    /**
     * Set angabeSignatur value
     * @param \StructType\Code_Signatur $angabeSignatur
     * @return \StructType\Formular
     */
    public function setAngabeSignatur(\StructType\Code_Signatur $angabeSignatur = null)
    {
        $this->angabeSignatur = $angabeSignatur;
        return $this;
    }
    /**
     * Get referenzFIMFormularID value
     * @return \StructType\Identifikator[]|null
     */
    public function getReferenzFIMFormularID()
    {
        return $this->referenzFIMFormularID;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenzFIMFormularID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenzFIMFormularID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenzFIMFormularIDForArrayConstraintsFromSetReferenzFIMFormularID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formularReferenzFIMFormularIDItem) {
            // validation for constraint: itemType
            if (!$formularReferenzFIMFormularIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($formularReferenzFIMFormularIDItem) ? get_class($formularReferenzFIMFormularIDItem) : sprintf('%s(%s)', gettype($formularReferenzFIMFormularIDItem), var_export($formularReferenzFIMFormularIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The referenzFIMFormularID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set referenzFIMFormularID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $referenzFIMFormularID
     * @return \StructType\Formular
     */
    public function setReferenzFIMFormularID(array $referenzFIMFormularID = array())
    {
        // validation for constraint: array
        if ('' !== ($referenzFIMFormularIDArrayErrorMessage = self::validateReferenzFIMFormularIDForArrayConstraintsFromSetReferenzFIMFormularID($referenzFIMFormularID))) {
            throw new \InvalidArgumentException($referenzFIMFormularIDArrayErrorMessage, __LINE__);
        }
        $this->referenzFIMFormularID = $referenzFIMFormularID;
        return $this;
    }
    /**
     * Add item to referenzFIMFormularID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Formular
     */
    public function addToReferenzFIMFormularID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The referenzFIMFormularID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->referenzFIMFormularID[] = $item;
        return $this;
    }
    /**
     * Get herausgeber value
     * @return \StructType\Herausgeber|null
     */
    public function getHerausgeber()
    {
        return $this->herausgeber;
    }
    /**
     * Set herausgeber value
     * @param \StructType\Herausgeber $herausgeber
     * @return \StructType\Formular
     */
    public function setHerausgeber(\StructType\Herausgeber $herausgeber = null)
    {
        $this->herausgeber = $herausgeber;
        return $this;
    }
    /**
     * Get versionsinformation value
     * @return \StructType\Versionsinformation|null
     */
    public function getVersionsinformation()
    {
        return $this->versionsinformation;
    }
    /**
     * Set versionsinformation value
     * @param \StructType\Versionsinformation $versionsinformation
     * @return \StructType\Formular
     */
    public function setVersionsinformation(\StructType\Versionsinformation $versionsinformation = null)
    {
        $this->versionsinformation = $versionsinformation;
        return $this;
    }
    /**
     * Get sprachversion value
     * @return \StructType\Sprachversion[]|null
     */
    public function getSprachversion()
    {
        return $this->sprachversion;
    }
    /**
     * This method is responsible for validating the values passed to the setSprachversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprachversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSprachversionForArrayConstraintsFromSetSprachversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formularSprachversionItem) {
            // validation for constraint: itemType
            if (!$formularSprachversionItem instanceof \StructType\Sprachversion) {
                $invalidValues[] = is_object($formularSprachversionItem) ? get_class($formularSprachversionItem) : sprintf('%s(%s)', gettype($formularSprachversionItem), var_export($formularSprachversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sprachversion property can only contain items of type \StructType\Sprachversion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sprachversion value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprachversion[] $sprachversion
     * @return \StructType\Formular
     */
    public function setSprachversion(array $sprachversion = array())
    {
        // validation for constraint: array
        if ('' !== ($sprachversionArrayErrorMessage = self::validateSprachversionForArrayConstraintsFromSetSprachversion($sprachversion))) {
            throw new \InvalidArgumentException($sprachversionArrayErrorMessage, __LINE__);
        }
        $this->sprachversion = $sprachversion;
        return $this;
    }
    /**
     * Add item to sprachversion value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprachversion $item
     * @return \StructType\Formular
     */
    public function addToSprachversion(\StructType\Sprachversion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sprachversion) {
            throw new \InvalidArgumentException(sprintf('The sprachversion property can only contain items of type \StructType\Sprachversion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sprachversion[] = $item;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formularGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$formularGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($formularGueltigkeitItem) ? get_class($formularGueltigkeitItem) : sprintf('%s(%s)', gettype($formularGueltigkeitItem), var_export($formularGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Formular
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Formular
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
