<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileType StructType
 * @subpackage Structs
 */
class FileType extends AbstractStructBase
{
    /**
     * The rangeParameters
     * @var \StructType\AssociationRoleType
     */
    public $rangeParameters;
    /**
     * The fileName
     * @var string
     */
    public $fileName;
    /**
     * The fileReference
     * @var string
     */
    public $fileReference;
    /**
     * The fileStructure
     * @var \StructType\CodeType
     */
    public $fileStructure;
    /**
     * The mimeType
     * @var string
     */
    public $mimeType;
    /**
     * The compression
     * @var string
     */
    public $compression;
    /**
     * Constructor method for FileType
     * @uses FileType::setRangeParameters()
     * @uses FileType::setFileName()
     * @uses FileType::setFileReference()
     * @uses FileType::setFileStructure()
     * @uses FileType::setMimeType()
     * @uses FileType::setCompression()
     * @param \StructType\AssociationRoleType $rangeParameters
     * @param string $fileName
     * @param string $fileReference
     * @param \StructType\CodeType $fileStructure
     * @param string $mimeType
     * @param string $compression
     */
    public function __construct(\StructType\AssociationRoleType $rangeParameters = null, $fileName = null, $fileReference = null, \StructType\CodeType $fileStructure = null, $mimeType = null, $compression = null)
    {
        $this
            ->setRangeParameters($rangeParameters)
            ->setFileName($fileName)
            ->setFileReference($fileReference)
            ->setFileStructure($fileStructure)
            ->setMimeType($mimeType)
            ->setCompression($compression);
    }
    /**
     * Get rangeParameters value
     * @return \StructType\AssociationRoleType|null
     */
    public function getRangeParameters()
    {
        return $this->rangeParameters;
    }
    /**
     * Set rangeParameters value
     * @param \StructType\AssociationRoleType $rangeParameters
     * @return \StructType\FileType
     */
    public function setRangeParameters(\StructType\AssociationRoleType $rangeParameters = null)
    {
        $this->rangeParameters = $rangeParameters;
        return $this;
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \StructType\FileType
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get fileReference value
     * @return string|null
     */
    public function getFileReference()
    {
        return $this->fileReference;
    }
    /**
     * Set fileReference value
     * @param string $fileReference
     * @return \StructType\FileType
     */
    public function setFileReference($fileReference = null)
    {
        // validation for constraint: string
        if (!is_null($fileReference) && !is_string($fileReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileReference, true), gettype($fileReference)), __LINE__);
        }
        $this->fileReference = $fileReference;
        return $this;
    }
    /**
     * Get fileStructure value
     * @return \StructType\CodeType|null
     */
    public function getFileStructure()
    {
        return $this->fileStructure;
    }
    /**
     * Set fileStructure value
     * @param \StructType\CodeType $fileStructure
     * @return \StructType\FileType
     */
    public function setFileStructure(\StructType\CodeType $fileStructure = null)
    {
        $this->fileStructure = $fileStructure;
        return $this;
    }
    /**
     * Get mimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->mimeType;
    }
    /**
     * Set mimeType value
     * @param string $mimeType
     * @return \StructType\FileType
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeType, true), gettype($mimeType)), __LINE__);
        }
        $this->mimeType = $mimeType;
        return $this;
    }
    /**
     * Get compression value
     * @return string|null
     */
    public function getCompression()
    {
        return $this->compression;
    }
    /**
     * Set compression value
     * @param string $compression
     * @return \StructType\FileType
     */
    public function setCompression($compression = null)
    {
        // validation for constraint: string
        if (!is_null($compression) && !is_string($compression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compression, true), gettype($compression)), __LINE__);
        }
        $this->compression = $compression;
        return $this;
    }
}
