<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extended StructType
 * @subpackage Structs
 */
class Extended extends AbstractStructBase
{
    /**
     * The title
     * @var \StructType\TitleEltType
     */
    public $title;
    /**
     * The resource
     * @var \StructType\ResourceType
     */
    public $resource;
    /**
     * The locator
     * @var \StructType\LocatorType
     */
    public $locator;
    /**
     * The arc
     * @var \StructType\ArcType
     */
    public $arc;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The role
     * @var string
     */
    public $role;
    /**
     * Constructor method for extended
     * @uses Extended::setTitle()
     * @uses Extended::setResource()
     * @uses Extended::setLocator()
     * @uses Extended::setArc()
     * @uses Extended::setType()
     * @uses Extended::setRole()
     * @param \StructType\TitleEltType $title
     * @param \StructType\ResourceType $resource
     * @param \StructType\LocatorType $locator
     * @param \StructType\ArcType $arc
     * @param string $type
     * @param string $role
     */
    public function __construct(\StructType\TitleEltType $title = null, \StructType\ResourceType $resource = null, \StructType\LocatorType $locator = null, \StructType\ArcType $arc = null, $type = null, $role = null)
    {
        $this
            ->setTitle($title)
            ->setResource($resource)
            ->setLocator($locator)
            ->setArc($arc)
            ->setType($type)
            ->setRole($role);
    }
    /**
     * Get title value
     * @return \StructType\TitleEltType|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param \StructType\TitleEltType $title
     * @return \StructType\Extended
     */
    public function setTitle(\StructType\TitleEltType $title = null)
    {
        $this->title = $title;
        return $this;
    }
    /**
     * Get resource value
     * @return \StructType\ResourceType|null
     */
    public function getResource()
    {
        return $this->resource;
    }
    /**
     * Set resource value
     * @param \StructType\ResourceType $resource
     * @return \StructType\Extended
     */
    public function setResource(\StructType\ResourceType $resource = null)
    {
        $this->resource = $resource;
        return $this;
    }
    /**
     * Get locator value
     * @return \StructType\LocatorType|null
     */
    public function getLocator()
    {
        return $this->locator;
    }
    /**
     * Set locator value
     * @param \StructType\LocatorType $locator
     * @return \StructType\Extended
     */
    public function setLocator(\StructType\LocatorType $locator = null)
    {
        $this->locator = $locator;
        return $this;
    }
    /**
     * Get arc value
     * @return \StructType\ArcType|null
     */
    public function getArc()
    {
        return $this->arc;
    }
    /**
     * Set arc value
     * @param \StructType\ArcType $arc
     * @return \StructType\Extended
     */
    public function setArc(\StructType\ArcType $arc = null)
    {
        $this->arc = $arc;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Extended
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \StructType\Extended
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
}
