<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnvelopeWithTimePeriodType StructType
 * @subpackage Structs
 */
class EnvelopeWithTimePeriodType extends AbstractStructBase
{
    /**
     * The beginPosition
     * @var \StructType\TimePositionType
     */
    public $beginPosition;
    /**
     * The endPosition
     * @var \StructType\TimePositionType
     */
    public $endPosition;
    /**
     * The frame
     * @var string
     */
    public $frame;
    /**
     * Constructor method for EnvelopeWithTimePeriodType
     * @uses EnvelopeWithTimePeriodType::setBeginPosition()
     * @uses EnvelopeWithTimePeriodType::setEndPosition()
     * @uses EnvelopeWithTimePeriodType::setFrame()
     * @param \StructType\TimePositionType $beginPosition
     * @param \StructType\TimePositionType $endPosition
     * @param string $frame
     */
    public function __construct(\StructType\TimePositionType $beginPosition = null, \StructType\TimePositionType $endPosition = null, $frame = null)
    {
        $this
            ->setBeginPosition($beginPosition)
            ->setEndPosition($endPosition)
            ->setFrame($frame);
    }
    /**
     * Get beginPosition value
     * @return \StructType\TimePositionType|null
     */
    public function getBeginPosition()
    {
        return $this->beginPosition;
    }
    /**
     * Set beginPosition value
     * @param \StructType\TimePositionType $beginPosition
     * @return \StructType\EnvelopeWithTimePeriodType
     */
    public function setBeginPosition(\StructType\TimePositionType $beginPosition = null)
    {
        $this->beginPosition = $beginPosition;
        return $this;
    }
    /**
     * Get endPosition value
     * @return \StructType\TimePositionType|null
     */
    public function getEndPosition()
    {
        return $this->endPosition;
    }
    /**
     * Set endPosition value
     * @param \StructType\TimePositionType $endPosition
     * @return \StructType\EnvelopeWithTimePeriodType
     */
    public function setEndPosition(\StructType\TimePositionType $endPosition = null)
    {
        $this->endPosition = $endPosition;
        return $this;
    }
    /**
     * Get frame value
     * @return string|null
     */
    public function getFrame()
    {
        return $this->frame;
    }
    /**
     * Set frame value
     * @param string $frame
     * @return \StructType\EnvelopeWithTimePeriodType
     */
    public function setFrame($frame = null)
    {
        // validation for constraint: string
        if (!is_null($frame) && !is_string($frame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frame, true), gettype($frame)), __LINE__);
        }
        $this->frame = $frame;
        return $this;
    }
}
