<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnvelopeType StructType
 * @subpackage Structs
 */
class EnvelopeType extends AbstractStructBase
{
    /**
     * The lowerCorner
     * @var \StructType\DirectPositionType
     */
    public $lowerCorner;
    /**
     * The upperCorner
     * @var \StructType\DirectPositionType
     */
    public $upperCorner;
    /**
     * The pos
     * @var \StructType\DirectPositionType
     */
    public $pos;
    /**
     * The coordinates
     * @var \StructType\CoordinatesType
     */
    public $coordinates;
    /**
     * The srsName
     * @var string
     */
    public $srsName;
    /**
     * The srsDimension
     * @var int
     */
    public $srsDimension;
    /**
     * The axisLabels
     * @var list
     */
    public $axisLabels;
    /**
     * The uomLabels
     * @var list
     */
    public $uomLabels;
    /**
     * Constructor method for EnvelopeType
     * @uses EnvelopeType::setLowerCorner()
     * @uses EnvelopeType::setUpperCorner()
     * @uses EnvelopeType::setPos()
     * @uses EnvelopeType::setCoordinates()
     * @uses EnvelopeType::setSrsName()
     * @uses EnvelopeType::setSrsDimension()
     * @uses EnvelopeType::setAxisLabels()
     * @uses EnvelopeType::setUomLabels()
     * @param \StructType\DirectPositionType $lowerCorner
     * @param \StructType\DirectPositionType $upperCorner
     * @param \StructType\DirectPositionType $pos
     * @param \StructType\CoordinatesType $coordinates
     * @param string $srsName
     * @param int $srsDimension
     * @param list $axisLabels
     * @param list $uomLabels
     */
    public function __construct(\StructType\DirectPositionType $lowerCorner = null, \StructType\DirectPositionType $upperCorner = null, \StructType\DirectPositionType $pos = null, \StructType\CoordinatesType $coordinates = null, $srsName = null, $srsDimension = null, list $axisLabels = null, list $uomLabels = null)
    {
        $this
            ->setLowerCorner($lowerCorner)
            ->setUpperCorner($upperCorner)
            ->setPos($pos)
            ->setCoordinates($coordinates)
            ->setSrsName($srsName)
            ->setSrsDimension($srsDimension)
            ->setAxisLabels($axisLabels)
            ->setUomLabels($uomLabels);
    }
    /**
     * Get lowerCorner value
     * @return \StructType\DirectPositionType|null
     */
    public function getLowerCorner()
    {
        return $this->lowerCorner;
    }
    /**
     * Set lowerCorner value
     * @param \StructType\DirectPositionType $lowerCorner
     * @return \StructType\EnvelopeType
     */
    public function setLowerCorner(\StructType\DirectPositionType $lowerCorner = null)
    {
        $this->lowerCorner = $lowerCorner;
        return $this;
    }
    /**
     * Get upperCorner value
     * @return \StructType\DirectPositionType|null
     */
    public function getUpperCorner()
    {
        return $this->upperCorner;
    }
    /**
     * Set upperCorner value
     * @param \StructType\DirectPositionType $upperCorner
     * @return \StructType\EnvelopeType
     */
    public function setUpperCorner(\StructType\DirectPositionType $upperCorner = null)
    {
        $this->upperCorner = $upperCorner;
        return $this;
    }
    /**
     * Get pos value
     * @return \StructType\DirectPositionType|null
     */
    public function getPos()
    {
        return $this->pos;
    }
    /**
     * Set pos value
     * @param \StructType\DirectPositionType $pos
     * @return \StructType\EnvelopeType
     */
    public function setPos(\StructType\DirectPositionType $pos = null)
    {
        $this->pos = $pos;
        return $this;
    }
    /**
     * Get coordinates value
     * @return \StructType\CoordinatesType|null
     */
    public function getCoordinates()
    {
        return $this->coordinates;
    }
    /**
     * Set coordinates value
     * @param \StructType\CoordinatesType $coordinates
     * @return \StructType\EnvelopeType
     */
    public function setCoordinates(\StructType\CoordinatesType $coordinates = null)
    {
        $this->coordinates = $coordinates;
        return $this;
    }
    /**
     * Get srsName value
     * @return string|null
     */
    public function getSrsName()
    {
        return $this->srsName;
    }
    /**
     * Set srsName value
     * @param string $srsName
     * @return \StructType\EnvelopeType
     */
    public function setSrsName($srsName = null)
    {
        // validation for constraint: string
        if (!is_null($srsName) && !is_string($srsName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srsName, true), gettype($srsName)), __LINE__);
        }
        $this->srsName = $srsName;
        return $this;
    }
    /**
     * Get srsDimension value
     * @return int|null
     */
    public function getSrsDimension()
    {
        return $this->srsDimension;
    }
    /**
     * Set srsDimension value
     * @param int $srsDimension
     * @return \StructType\EnvelopeType
     */
    public function setSrsDimension($srsDimension = null)
    {
        // validation for constraint: int
        if (!is_null($srsDimension) && !(is_int($srsDimension) || ctype_digit($srsDimension))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($srsDimension, true), gettype($srsDimension)), __LINE__);
        }
        $this->srsDimension = $srsDimension;
        return $this;
    }
    /**
     * Get axisLabels value
     * @return list|null
     */
    public function getAxisLabels()
    {
        return $this->axisLabels;
    }
    /**
     * Set axisLabels value
     * @param list $axisLabels
     * @return \StructType\EnvelopeType
     */
    public function setAxisLabels(list $axisLabels = null)
    {
        $this->axisLabels = $axisLabels;
        return $this;
    }
    /**
     * Get uomLabels value
     * @return list|null
     */
    public function getUomLabels()
    {
        return $this->uomLabels;
    }
    /**
     * Set uomLabels value
     * @param list $uomLabels
     * @return \StructType\EnvelopeType
     */
    public function setUomLabels(list $uomLabels = null)
    {
        $this->uomLabels = $uomLabels;
        return $this;
    }
}
