<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryType StructType
 * @subpackage Structs
 */
class DictionaryType extends AbstractStructBase
{
    /**
     * The dictionaryEntry
     * @var \StructType\DictionaryEntryType
     */
    public $dictionaryEntry;
    /**
     * The indirectEntry
     * @var \StructType\IndirectEntryType
     */
    public $indirectEntry;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for DictionaryType
     * @uses DictionaryType::setDictionaryEntry()
     * @uses DictionaryType::setIndirectEntry()
     * @uses DictionaryType::setAggregationType()
     * @param \StructType\DictionaryEntryType $dictionaryEntry
     * @param \StructType\IndirectEntryType $indirectEntry
     * @param string $aggregationType
     */
    public function __construct(\StructType\DictionaryEntryType $dictionaryEntry = null, \StructType\IndirectEntryType $indirectEntry = null, $aggregationType = null)
    {
        $this
            ->setDictionaryEntry($dictionaryEntry)
            ->setIndirectEntry($indirectEntry)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get dictionaryEntry value
     * @return \StructType\DictionaryEntryType|null
     */
    public function getDictionaryEntry()
    {
        return $this->dictionaryEntry;
    }
    /**
     * Set dictionaryEntry value
     * @param \StructType\DictionaryEntryType $dictionaryEntry
     * @return \StructType\DictionaryType
     */
    public function setDictionaryEntry(\StructType\DictionaryEntryType $dictionaryEntry = null)
    {
        $this->dictionaryEntry = $dictionaryEntry;
        return $this;
    }
    /**
     * Get indirectEntry value
     * @return \StructType\IndirectEntryType|null
     */
    public function getIndirectEntry()
    {
        return $this->indirectEntry;
    }
    /**
     * Set indirectEntry value
     * @param \StructType\IndirectEntryType $indirectEntry
     * @return \StructType\DictionaryType
     */
    public function setIndirectEntry(\StructType\IndirectEntryType $indirectEntry = null)
    {
        $this->indirectEntry = $indirectEntry;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\DictionaryType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
