<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DefinitionType StructType
 * @subpackage Structs
 */
class DefinitionType extends AbstractStructBase
{
    /**
     * The remarks
     * @var string
     */
    public $remarks;
    /**
     * Constructor method for DefinitionType
     * @uses DefinitionType::setRemarks()
     * @param string $remarks
     */
    public function __construct($remarks = null)
    {
        $this
            ->setRemarks($remarks);
    }
    /**
     * Get remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->remarks;
    }
    /**
     * Set remarks value
     * @param string $remarks
     * @return \StructType\DefinitionType
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->remarks = $remarks;
        return $this;
    }
}
