<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Date_PropertyType StructType
 * @subpackage Structs
 */
class Date_PropertyType extends AbstractStructBase
{
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The DateTime
     * @var string
     */
    public $DateTime;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for Date_PropertyType
     * @uses Date_PropertyType::setDate()
     * @uses Date_PropertyType::setDateTime()
     * @uses Date_PropertyType::setNilReason()
     * @param string $date
     * @param string $dateTime
     * @param string $nilReason
     */
    public function __construct($date = null, $dateTime = null, $nilReason = null)
    {
        $this
            ->setDate($date)
            ->setDateTime($dateTime)
            ->setNilReason($nilReason);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Date_PropertyType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\Date_PropertyType
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\Date_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
