<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateTime_PropertyType StructType
 * @subpackage Structs
 */
class DateTime_PropertyType extends AbstractStructBase
{
    /**
     * The DateTime
     * @var string
     */
    public $DateTime;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for DateTime_PropertyType
     * @uses DateTime_PropertyType::setDateTime()
     * @uses DateTime_PropertyType::setNilReason()
     * @param string $dateTime
     * @param string $nilReason
     */
    public function __construct($dateTime = null, $nilReason = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setNilReason($nilReason);
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\DateTime_PropertyType
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\DateTime_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
