<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DMSAngleType StructType
 * @subpackage Structs
 */
class DMSAngleType extends AbstractStructBase
{
    /**
     * The degrees
     * @var \StructType\DegreesType
     */
    public $degrees;
    /**
     * The decimalMinutes
     * @var float
     */
    public $decimalMinutes;
    /**
     * The minutes
     * @var int
     */
    public $minutes;
    /**
     * The seconds
     * @var float
     */
    public $seconds;
    /**
     * Constructor method for DMSAngleType
     * @uses DMSAngleType::setDegrees()
     * @uses DMSAngleType::setDecimalMinutes()
     * @uses DMSAngleType::setMinutes()
     * @uses DMSAngleType::setSeconds()
     * @param \StructType\DegreesType $degrees
     * @param float $decimalMinutes
     * @param int $minutes
     * @param float $seconds
     */
    public function __construct(\StructType\DegreesType $degrees = null, $decimalMinutes = null, $minutes = null, $seconds = null)
    {
        $this
            ->setDegrees($degrees)
            ->setDecimalMinutes($decimalMinutes)
            ->setMinutes($minutes)
            ->setSeconds($seconds);
    }
    /**
     * Get degrees value
     * @return \StructType\DegreesType|null
     */
    public function getDegrees()
    {
        return $this->degrees;
    }
    /**
     * Set degrees value
     * @param \StructType\DegreesType $degrees
     * @return \StructType\DMSAngleType
     */
    public function setDegrees(\StructType\DegreesType $degrees = null)
    {
        $this->degrees = $degrees;
        return $this;
    }
    /**
     * Get decimalMinutes value
     * @return float|null
     */
    public function getDecimalMinutes()
    {
        return $this->decimalMinutes;
    }
    /**
     * Set decimalMinutes value
     * @param float $decimalMinutes
     * @return \StructType\DMSAngleType
     */
    public function setDecimalMinutes($decimalMinutes = null)
    {
        // validation for constraint: float
        if (!is_null($decimalMinutes) && !(is_float($decimalMinutes) || is_numeric($decimalMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($decimalMinutes, true), gettype($decimalMinutes)), __LINE__);
        }
        $this->decimalMinutes = $decimalMinutes;
        return $this;
    }
    /**
     * Get minutes value
     * @return int|null
     */
    public function getMinutes()
    {
        return $this->minutes;
    }
    /**
     * Set minutes value
     * @param int $minutes
     * @return \StructType\DMSAngleType
     */
    public function setMinutes($minutes = null)
    {
        // validation for constraint: int
        if (!is_null($minutes) && !(is_int($minutes) || ctype_digit($minutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minutes, true), gettype($minutes)), __LINE__);
        }
        $this->minutes = $minutes;
        return $this;
    }
    /**
     * Get seconds value
     * @return float|null
     */
    public function getSeconds()
    {
        return $this->seconds;
    }
    /**
     * Set seconds value
     * @param float $seconds
     * @return \StructType\DMSAngleType
     */
    public function setSeconds($seconds = null)
    {
        // validation for constraint: float
        if (!is_null($seconds) && !(is_float($seconds) || is_numeric($seconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($seconds, true), gettype($seconds)), __LINE__);
        }
        $this->seconds = $seconds;
        return $this;
    }
}
