<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CubicSplineType StructType
 * @subpackage Structs
 */
class CubicSplineType extends AbstractStructBase
{
    /**
     * The pos
     * @var \StructType\DirectPositionType
     */
    public $pos;
    /**
     * The pointProperty
     * @var \StructType\PointPropertyType
     */
    public $pointProperty;
    /**
     * The pointRep
     * @var \StructType\PointPropertyType
     */
    public $pointRep;
    /**
     * The posList
     * @var \StructType\DirectPositionListType
     */
    public $posList;
    /**
     * The coordinates
     * @var \StructType\CoordinatesType
     */
    public $coordinates;
    /**
     * The vectorAtStart
     * @var \StructType\VectorType
     */
    public $vectorAtStart;
    /**
     * The vectorAtEnd
     * @var \StructType\VectorType
     */
    public $vectorAtEnd;
    /**
     * The interpolation
     * @var string
     */
    public $interpolation;
    /**
     * The degree
     * @var int
     */
    public $degree;
    /**
     * Constructor method for CubicSplineType
     * @uses CubicSplineType::setPos()
     * @uses CubicSplineType::setPointProperty()
     * @uses CubicSplineType::setPointRep()
     * @uses CubicSplineType::setPosList()
     * @uses CubicSplineType::setCoordinates()
     * @uses CubicSplineType::setVectorAtStart()
     * @uses CubicSplineType::setVectorAtEnd()
     * @uses CubicSplineType::setInterpolation()
     * @uses CubicSplineType::setDegree()
     * @param \StructType\DirectPositionType $pos
     * @param \StructType\PointPropertyType $pointProperty
     * @param \StructType\PointPropertyType $pointRep
     * @param \StructType\DirectPositionListType $posList
     * @param \StructType\CoordinatesType $coordinates
     * @param \StructType\VectorType $vectorAtStart
     * @param \StructType\VectorType $vectorAtEnd
     * @param string $interpolation
     * @param int $degree
     */
    public function __construct(\StructType\DirectPositionType $pos = null, \StructType\PointPropertyType $pointProperty = null, \StructType\PointPropertyType $pointRep = null, \StructType\DirectPositionListType $posList = null, \StructType\CoordinatesType $coordinates = null, \StructType\VectorType $vectorAtStart = null, \StructType\VectorType $vectorAtEnd = null, $interpolation = null, $degree = null)
    {
        $this
            ->setPos($pos)
            ->setPointProperty($pointProperty)
            ->setPointRep($pointRep)
            ->setPosList($posList)
            ->setCoordinates($coordinates)
            ->setVectorAtStart($vectorAtStart)
            ->setVectorAtEnd($vectorAtEnd)
            ->setInterpolation($interpolation)
            ->setDegree($degree);
    }
    /**
     * Get pos value
     * @return \StructType\DirectPositionType|null
     */
    public function getPos()
    {
        return $this->pos;
    }
    /**
     * Set pos value
     * @param \StructType\DirectPositionType $pos
     * @return \StructType\CubicSplineType
     */
    public function setPos(\StructType\DirectPositionType $pos = null)
    {
        $this->pos = $pos;
        return $this;
    }
    /**
     * Get pointProperty value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointProperty()
    {
        return $this->pointProperty;
    }
    /**
     * Set pointProperty value
     * @param \StructType\PointPropertyType $pointProperty
     * @return \StructType\CubicSplineType
     */
    public function setPointProperty(\StructType\PointPropertyType $pointProperty = null)
    {
        $this->pointProperty = $pointProperty;
        return $this;
    }
    /**
     * Get pointRep value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointRep()
    {
        return $this->pointRep;
    }
    /**
     * Set pointRep value
     * @param \StructType\PointPropertyType $pointRep
     * @return \StructType\CubicSplineType
     */
    public function setPointRep(\StructType\PointPropertyType $pointRep = null)
    {
        $this->pointRep = $pointRep;
        return $this;
    }
    /**
     * Get posList value
     * @return \StructType\DirectPositionListType|null
     */
    public function getPosList()
    {
        return $this->posList;
    }
    /**
     * Set posList value
     * @param \StructType\DirectPositionListType $posList
     * @return \StructType\CubicSplineType
     */
    public function setPosList(\StructType\DirectPositionListType $posList = null)
    {
        $this->posList = $posList;
        return $this;
    }
    /**
     * Get coordinates value
     * @return \StructType\CoordinatesType|null
     */
    public function getCoordinates()
    {
        return $this->coordinates;
    }
    /**
     * Set coordinates value
     * @param \StructType\CoordinatesType $coordinates
     * @return \StructType\CubicSplineType
     */
    public function setCoordinates(\StructType\CoordinatesType $coordinates = null)
    {
        $this->coordinates = $coordinates;
        return $this;
    }
    /**
     * Get vectorAtStart value
     * @return \StructType\VectorType|null
     */
    public function getVectorAtStart()
    {
        return $this->vectorAtStart;
    }
    /**
     * Set vectorAtStart value
     * @param \StructType\VectorType $vectorAtStart
     * @return \StructType\CubicSplineType
     */
    public function setVectorAtStart(\StructType\VectorType $vectorAtStart = null)
    {
        $this->vectorAtStart = $vectorAtStart;
        return $this;
    }
    /**
     * Get vectorAtEnd value
     * @return \StructType\VectorType|null
     */
    public function getVectorAtEnd()
    {
        return $this->vectorAtEnd;
    }
    /**
     * Set vectorAtEnd value
     * @param \StructType\VectorType $vectorAtEnd
     * @return \StructType\CubicSplineType
     */
    public function setVectorAtEnd(\StructType\VectorType $vectorAtEnd = null)
    {
        $this->vectorAtEnd = $vectorAtEnd;
        return $this;
    }
    /**
     * Get interpolation value
     * @return string|null
     */
    public function getInterpolation()
    {
        return $this->interpolation;
    }
    /**
     * Set interpolation value
     * @param string $interpolation
     * @return \StructType\CubicSplineType
     */
    public function setInterpolation($interpolation = null)
    {
        // validation for constraint: string
        if (!is_null($interpolation) && !is_string($interpolation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interpolation, true), gettype($interpolation)), __LINE__);
        }
        $this->interpolation = $interpolation;
        return $this;
    }
    /**
     * Get degree value
     * @return int|null
     */
    public function getDegree()
    {
        return $this->degree;
    }
    /**
     * Set degree value
     * @param int $degree
     * @return \StructType\CubicSplineType
     */
    public function setDegree($degree = null)
    {
        // validation for constraint: int
        if (!is_null($degree) && !(is_int($degree) || ctype_digit($degree))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($degree, true), gettype($degree)), __LINE__);
        }
        $this->degree = $degree;
        return $this;
    }
}
