<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoordinateSystemAxisType StructType
 * @subpackage Structs
 */
class CoordinateSystemAxisType extends AbstractStructBase
{
    /**
     * The axisAbbrev
     * @var \StructType\CodeType
     */
    public $axisAbbrev;
    /**
     * The axisDirection
     * @var \StructType\CodeWithAuthorityType
     */
    public $axisDirection;
    /**
     * The minimumValue
     * @var float
     */
    public $minimumValue;
    /**
     * The maximumValue
     * @var float
     */
    public $maximumValue;
    /**
     * The rangeMeaning
     * @var \StructType\CodeWithAuthorityType
     */
    public $rangeMeaning;
    /**
     * The uom
     * @var string
     */
    public $uom;
    /**
     * Constructor method for CoordinateSystemAxisType
     * @uses CoordinateSystemAxisType::setAxisAbbrev()
     * @uses CoordinateSystemAxisType::setAxisDirection()
     * @uses CoordinateSystemAxisType::setMinimumValue()
     * @uses CoordinateSystemAxisType::setMaximumValue()
     * @uses CoordinateSystemAxisType::setRangeMeaning()
     * @uses CoordinateSystemAxisType::setUom()
     * @param \StructType\CodeType $axisAbbrev
     * @param \StructType\CodeWithAuthorityType $axisDirection
     * @param float $minimumValue
     * @param float $maximumValue
     * @param \StructType\CodeWithAuthorityType $rangeMeaning
     * @param string $uom
     */
    public function __construct(\StructType\CodeType $axisAbbrev = null, \StructType\CodeWithAuthorityType $axisDirection = null, $minimumValue = null, $maximumValue = null, \StructType\CodeWithAuthorityType $rangeMeaning = null, $uom = null)
    {
        $this
            ->setAxisAbbrev($axisAbbrev)
            ->setAxisDirection($axisDirection)
            ->setMinimumValue($minimumValue)
            ->setMaximumValue($maximumValue)
            ->setRangeMeaning($rangeMeaning)
            ->setUom($uom);
    }
    /**
     * Get axisAbbrev value
     * @return \StructType\CodeType|null
     */
    public function getAxisAbbrev()
    {
        return $this->axisAbbrev;
    }
    /**
     * Set axisAbbrev value
     * @param \StructType\CodeType $axisAbbrev
     * @return \StructType\CoordinateSystemAxisType
     */
    public function setAxisAbbrev(\StructType\CodeType $axisAbbrev = null)
    {
        $this->axisAbbrev = $axisAbbrev;
        return $this;
    }
    /**
     * Get axisDirection value
     * @return \StructType\CodeWithAuthorityType|null
     */
    public function getAxisDirection()
    {
        return $this->axisDirection;
    }
    /**
     * Set axisDirection value
     * @param \StructType\CodeWithAuthorityType $axisDirection
     * @return \StructType\CoordinateSystemAxisType
     */
    public function setAxisDirection(\StructType\CodeWithAuthorityType $axisDirection = null)
    {
        $this->axisDirection = $axisDirection;
        return $this;
    }
    /**
     * Get minimumValue value
     * @return float|null
     */
    public function getMinimumValue()
    {
        return $this->minimumValue;
    }
    /**
     * Set minimumValue value
     * @param float $minimumValue
     * @return \StructType\CoordinateSystemAxisType
     */
    public function setMinimumValue($minimumValue = null)
    {
        // validation for constraint: float
        if (!is_null($minimumValue) && !(is_float($minimumValue) || is_numeric($minimumValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumValue, true), gettype($minimumValue)), __LINE__);
        }
        $this->minimumValue = $minimumValue;
        return $this;
    }
    /**
     * Get maximumValue value
     * @return float|null
     */
    public function getMaximumValue()
    {
        return $this->maximumValue;
    }
    /**
     * Set maximumValue value
     * @param float $maximumValue
     * @return \StructType\CoordinateSystemAxisType
     */
    public function setMaximumValue($maximumValue = null)
    {
        // validation for constraint: float
        if (!is_null($maximumValue) && !(is_float($maximumValue) || is_numeric($maximumValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumValue, true), gettype($maximumValue)), __LINE__);
        }
        $this->maximumValue = $maximumValue;
        return $this;
    }
    /**
     * Get rangeMeaning value
     * @return \StructType\CodeWithAuthorityType|null
     */
    public function getRangeMeaning()
    {
        return $this->rangeMeaning;
    }
    /**
     * Set rangeMeaning value
     * @param \StructType\CodeWithAuthorityType $rangeMeaning
     * @return \StructType\CoordinateSystemAxisType
     */
    public function setRangeMeaning(\StructType\CodeWithAuthorityType $rangeMeaning = null)
    {
        $this->rangeMeaning = $rangeMeaning;
        return $this;
    }
    /**
     * Get uom value
     * @return string|null
     */
    public function getUom()
    {
        return $this->uom;
    }
    /**
     * Set uom value
     * @param string $uom
     * @return \StructType\CoordinateSystemAxisType
     */
    public function setUom($uom = null)
    {
        // validation for constraint: string
        if (!is_null($uom) && !is_string($uom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uom, true), gettype($uom)), __LINE__);
        }
        $this->uom = $uom;
        return $this;
    }
}
