<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConversionToPreferredUnitType StructType
 * @subpackage Structs
 */
class ConversionToPreferredUnitType extends AbstractStructBase
{
    /**
     * The factor
     * @var float
     */
    public $factor;
    /**
     * The formula
     * @var \StructType\FormulaType
     */
    public $formula;
    /**
     * Constructor method for ConversionToPreferredUnitType
     * @uses ConversionToPreferredUnitType::setFactor()
     * @uses ConversionToPreferredUnitType::setFormula()
     * @param float $factor
     * @param \StructType\FormulaType $formula
     */
    public function __construct($factor = null, \StructType\FormulaType $formula = null)
    {
        $this
            ->setFactor($factor)
            ->setFormula($formula);
    }
    /**
     * Get factor value
     * @return float|null
     */
    public function getFactor()
    {
        return $this->factor;
    }
    /**
     * Set factor value
     * @param float $factor
     * @return \StructType\ConversionToPreferredUnitType
     */
    public function setFactor($factor = null)
    {
        // validation for constraint: float
        if (!is_null($factor) && !(is_float($factor) || is_numeric($factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($factor, true), gettype($factor)), __LINE__);
        }
        $this->factor = $factor;
        return $this;
    }
    /**
     * Get formula value
     * @return \StructType\FormulaType|null
     */
    public function getFormula()
    {
        return $this->formula;
    }
    /**
     * Set formula value
     * @param \StructType\FormulaType $formula
     * @return \StructType\ConversionToPreferredUnitType
     */
    public function setFormula(\StructType\FormulaType $formula = null)
    {
        $this->formula = $formula;
        return $this;
    }
}
