<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompositeSurfaceType StructType
 * @subpackage Structs
 */
class CompositeSurfaceType extends AbstractStructBase
{
    /**
     * The surfaceMember
     * @var \StructType\SurfacePropertyType
     */
    public $surfaceMember;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for CompositeSurfaceType
     * @uses CompositeSurfaceType::setSurfaceMember()
     * @uses CompositeSurfaceType::setAggregationType()
     * @param \StructType\SurfacePropertyType $surfaceMember
     * @param string $aggregationType
     */
    public function __construct(\StructType\SurfacePropertyType $surfaceMember = null, $aggregationType = null)
    {
        $this
            ->setSurfaceMember($surfaceMember)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get surfaceMember value
     * @return \StructType\SurfacePropertyType|null
     */
    public function getSurfaceMember()
    {
        return $this->surfaceMember;
    }
    /**
     * Set surfaceMember value
     * @param \StructType\SurfacePropertyType $surfaceMember
     * @return \StructType\CompositeSurfaceType
     */
    public function setSurfaceMember(\StructType\SurfacePropertyType $surfaceMember = null)
    {
        $this->surfaceMember = $surfaceMember;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\CompositeSurfaceType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
