<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompositeSolidType StructType
 * @subpackage Structs
 */
class CompositeSolidType extends AbstractStructBase
{
    /**
     * The solidMember
     * @var \StructType\SolidPropertyType
     */
    public $solidMember;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for CompositeSolidType
     * @uses CompositeSolidType::setSolidMember()
     * @uses CompositeSolidType::setAggregationType()
     * @param \StructType\SolidPropertyType $solidMember
     * @param string $aggregationType
     */
    public function __construct(\StructType\SolidPropertyType $solidMember = null, $aggregationType = null)
    {
        $this
            ->setSolidMember($solidMember)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get solidMember value
     * @return \StructType\SolidPropertyType|null
     */
    public function getSolidMember()
    {
        return $this->solidMember;
    }
    /**
     * Set solidMember value
     * @param \StructType\SolidPropertyType $solidMember
     * @return \StructType\CompositeSolidType
     */
    public function setSolidMember(\StructType\SolidPropertyType $solidMember = null)
    {
        $this->solidMember = $solidMember;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\CompositeSolidType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
