<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Code.RegionalschluesselDestatis StructType
 * Meta information extracted from the WSDL
 * - documentation: Regionalschlüssel (vom Statistischen Bundesamt Deutschland). Die Codeliste steht im XRepository zur Verfügung.
 * @subpackage Structs
 */
class Code_RegionalschluesselDestatis extends AbstractStructBase
{
    /**
     * The listVersionID
     * Meta information extracted from the WSDL
     * - documentation: Die konkrete Version der zu nutzenden Codeliste wird mit diesem XML-Attribut übertragen.Analog zum listURI ist die Bestimmung der Version einer Codeliste bei der Übertragung eines Codes zwingend. Die Version kann jedoch ebenfalls
     * bereits im XÖV-Standard festgelegt werden (es handelt sich in diesem Fall um einen Code-Typ 1 oder 2). | Dokumentation aus XÖV-Bibliothek:
     * - use: required
     * @var string
     */
    public $listVersionID;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - documentation: In diesem XML-Element wird der Code einer Codeliste übermittelt. | Dokumentation aus XÖV-Bibliothek:
     * - form: unqualified
     * @var string
     */
    public $code;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Mit diesem optionalen XML-Element kann die Beschreibung des Codes, wie in der jeweiligen Beschreibungsspalte der Codeliste vorgegeben, übermittelt werden. | Dokumentation aus XÖV-Bibliothek:
     * - form: unqualified
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The listURI
     * Meta information extracted from the WSDL
     * - documentation: Mit diesem XML-Attribut wird die Kennung der Codeliste übermittelt, in deren Kontext der jeweilige Code zu interpretieren ist. Die Kennung identifiziert die Codeliste, nicht jedoch deren Version eindeutig.Wird bereits im Rahmen des
     * XÖV-Standards eine Kennung vorgegeben (es handelt sich in diesem Fall um einen Code-Typ 1, 2 oder 3) darf auf eine nochmalige Angabe der Kennung bei der Übermittlung eines Codes verzichtet werden. Aus diesem Grund ist das XML-Attribut listURI
     * zunächst als optional deklariert. | Dokumentation aus XÖV-Bibliothek:
     * - fixed: urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:rs
     * - use: optional
     * @var string
     */
    public $listURI;
    /**
     * Constructor method for Code.RegionalschluesselDestatis
     * @uses Code_RegionalschluesselDestatis::setListVersionID()
     * @uses Code_RegionalschluesselDestatis::setCode()
     * @uses Code_RegionalschluesselDestatis::setName()
     * @uses Code_RegionalschluesselDestatis::setListURI()
     * @param string $listVersionID
     * @param string $code
     * @param string $name
     * @param string $listURI
     */
    public function __construct($listVersionID = null, $code = null, $name = null, $listURI = null)
    {
        $this
            ->setListVersionID($listVersionID)
            ->setCode($code)
            ->setName($name)
            ->setListURI($listURI);
    }
    /**
     * Get listVersionID value
     * @return string
     */
    public function getListVersionID()
    {
        return $this->listVersionID;
    }
    /**
     * Set listVersionID value
     * @param string $listVersionID
     * @return \StructType\Code_RegionalschluesselDestatis
     */
    public function setListVersionID($listVersionID = null)
    {
        // validation for constraint: string
        if (!is_null($listVersionID) && !is_string($listVersionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listVersionID, true), gettype($listVersionID)), __LINE__);
        }
        $this->listVersionID = $listVersionID;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Code_RegionalschluesselDestatis
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Code_RegionalschluesselDestatis
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get listURI value
     * @return string|null
     */
    public function getListURI()
    {
        return $this->listURI;
    }
    /**
     * Set listURI value
     * @param string $listURI
     * @return \StructType\Code_RegionalschluesselDestatis
     */
    public function setListURI($listURI = null)
    {
        // validation for constraint: string
        if (!is_null($listURI) && !is_string($listURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listURI, true), gettype($listURI)), __LINE__);
        }
        $this->listURI = $listURI;
        return $this;
    }
}
