<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Code.OnlinedienstDynamischerParameterTyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Codes für dynamische URL-Parameter für Links zum Aufruf von Onlinediensten.
 * @subpackage Structs
 */
class Code_OnlinedienstDynamischerParameterTyp extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - documentation: In diesem XML-Element wird der Code einer Codeliste übermittelt. | Dokumentation aus XÖV-Bibliothek:
     * - form: unqualified
     * @var string
     */
    public $code;
    /**
     * The listURI
     * Meta information extracted from the WSDL
     * - documentation: Mit diesem XML-Attribut wird die Kennung der Codeliste übermittelt, in deren Kontext der jeweilige Code zu interpretieren ist. Die Kennung identifiziert die Codeliste, nicht jedoch deren Version eindeutig.Wird bereits im Rahmen des
     * XÖV-Standards eine Kennung vorgegeben (es handelt sich in diesem Fall um einen Code-Typ 1, 2 oder 3) darf auf eine nochmalige Angabe der Kennung bei der Übermittlung eines Codes verzichtet werden. Aus diesem Grund ist das XML-Attribut listURI
     * zunächst als optional deklariert. | Dokumentation aus XÖV-Bibliothek:
     * - fixed: urn:xoev-de:fim:codeliste:xzufi.onlinedienstdynamischerparametertyp
     * - use: optional
     * @var string
     */
    public $listURI;
    /**
     * The listVersionID
     * Meta information extracted from the WSDL
     * - documentation: Die konkrete Version der zu nutzenden Codeliste wird mit diesem XML-Attribut übertragen.Analog zum listURI ist die Bestimmung der Version einer Codeliste bei der Übertragung eines Codes zwingend. Die Version kann jedoch ebenfalls
     * bereits im XÖV-Standard festgelegt werden (es handelt sich in diesem Fall um einen Code-Typ 1 oder 2). | Dokumentation aus XÖV-Bibliothek:
     * - fixed: 1
     * - use: optional
     * @var string
     */
    public $listVersionID;
    /**
     * Constructor method for Code.OnlinedienstDynamischerParameterTyp
     * @uses Code_OnlinedienstDynamischerParameterTyp::setCode()
     * @uses Code_OnlinedienstDynamischerParameterTyp::setListURI()
     * @uses Code_OnlinedienstDynamischerParameterTyp::setListVersionID()
     * @param string $code
     * @param string $listURI
     * @param string $listVersionID
     */
    public function __construct($code = null, $listURI = null, $listVersionID = null)
    {
        $this
            ->setCode($code)
            ->setListURI($listURI)
            ->setListVersionID($listVersionID);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @uses \EnumType\Codeliste_OnlinedienstDynamischerParameterTyp::valueIsValid()
     * @uses \EnumType\Codeliste_OnlinedienstDynamischerParameterTyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\Code_OnlinedienstDynamischerParameterTyp
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Codeliste_OnlinedienstDynamischerParameterTyp::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Codeliste_OnlinedienstDynamischerParameterTyp', is_array($code) ? implode(', ', $code) : var_export($code, true), implode(', ', \EnumType\Codeliste_OnlinedienstDynamischerParameterTyp::getValidValues())), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get listURI value
     * @return string|null
     */
    public function getListURI()
    {
        return $this->listURI;
    }
    /**
     * Set listURI value
     * @param string $listURI
     * @return \StructType\Code_OnlinedienstDynamischerParameterTyp
     */
    public function setListURI($listURI = null)
    {
        // validation for constraint: string
        if (!is_null($listURI) && !is_string($listURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listURI, true), gettype($listURI)), __LINE__);
        }
        $this->listURI = $listURI;
        return $this;
    }
    /**
     * Get listVersionID value
     * @return string|null
     */
    public function getListVersionID()
    {
        return $this->listVersionID;
    }
    /**
     * Set listVersionID value
     * @param string $listVersionID
     * @return \StructType\Code_OnlinedienstDynamischerParameterTyp
     */
    public function setListVersionID($listVersionID = null)
    {
        // validation for constraint: string
        if (!is_null($listVersionID) && !is_string($listVersionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listVersionID, true), gettype($listVersionID)), __LINE__);
        }
        $this->listVersionID = $listVersionID;
        return $this;
    }
}
