<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClothoidType StructType
 * @subpackage Structs
 */
class ClothoidType extends AbstractStructBase
{
    /**
     * The refLocation
     * @var \StructType\RefLocation
     */
    public $refLocation;
    /**
     * The scaleFactor
     * @var float
     */
    public $scaleFactor;
    /**
     * The startParameter
     * @var float
     */
    public $startParameter;
    /**
     * The endParameter
     * @var float
     */
    public $endParameter;
    /**
     * The interpolation
     * @var string
     */
    public $interpolation;
    /**
     * Constructor method for ClothoidType
     * @uses ClothoidType::setRefLocation()
     * @uses ClothoidType::setScaleFactor()
     * @uses ClothoidType::setStartParameter()
     * @uses ClothoidType::setEndParameter()
     * @uses ClothoidType::setInterpolation()
     * @param \StructType\RefLocation $refLocation
     * @param float $scaleFactor
     * @param float $startParameter
     * @param float $endParameter
     * @param string $interpolation
     */
    public function __construct(\StructType\RefLocation $refLocation = null, $scaleFactor = null, $startParameter = null, $endParameter = null, $interpolation = null)
    {
        $this
            ->setRefLocation($refLocation)
            ->setScaleFactor($scaleFactor)
            ->setStartParameter($startParameter)
            ->setEndParameter($endParameter)
            ->setInterpolation($interpolation);
    }
    /**
     * Get refLocation value
     * @return \StructType\RefLocation|null
     */
    public function getRefLocation()
    {
        return $this->refLocation;
    }
    /**
     * Set refLocation value
     * @param \StructType\RefLocation $refLocation
     * @return \StructType\ClothoidType
     */
    public function setRefLocation(\StructType\RefLocation $refLocation = null)
    {
        $this->refLocation = $refLocation;
        return $this;
    }
    /**
     * Get scaleFactor value
     * @return float|null
     */
    public function getScaleFactor()
    {
        return $this->scaleFactor;
    }
    /**
     * Set scaleFactor value
     * @param float $scaleFactor
     * @return \StructType\ClothoidType
     */
    public function setScaleFactor($scaleFactor = null)
    {
        // validation for constraint: float
        if (!is_null($scaleFactor) && !(is_float($scaleFactor) || is_numeric($scaleFactor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scaleFactor, true), gettype($scaleFactor)), __LINE__);
        }
        $this->scaleFactor = $scaleFactor;
        return $this;
    }
    /**
     * Get startParameter value
     * @return float|null
     */
    public function getStartParameter()
    {
        return $this->startParameter;
    }
    /**
     * Set startParameter value
     * @param float $startParameter
     * @return \StructType\ClothoidType
     */
    public function setStartParameter($startParameter = null)
    {
        // validation for constraint: float
        if (!is_null($startParameter) && !(is_float($startParameter) || is_numeric($startParameter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($startParameter, true), gettype($startParameter)), __LINE__);
        }
        $this->startParameter = $startParameter;
        return $this;
    }
    /**
     * Get endParameter value
     * @return float|null
     */
    public function getEndParameter()
    {
        return $this->endParameter;
    }
    /**
     * Set endParameter value
     * @param float $endParameter
     * @return \StructType\ClothoidType
     */
    public function setEndParameter($endParameter = null)
    {
        // validation for constraint: float
        if (!is_null($endParameter) && !(is_float($endParameter) || is_numeric($endParameter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($endParameter, true), gettype($endParameter)), __LINE__);
        }
        $this->endParameter = $endParameter;
        return $this;
    }
    /**
     * Get interpolation value
     * @return string|null
     */
    public function getInterpolation()
    {
        return $this->interpolation;
    }
    /**
     * Set interpolation value
     * @param string $interpolation
     * @return \StructType\ClothoidType
     */
    public function setInterpolation($interpolation = null)
    {
        // validation for constraint: string
        if (!is_null($interpolation) && !is_string($interpolation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interpolation, true), gettype($interpolation)), __LINE__);
        }
        $this->interpolation = $interpolation;
        return $this;
    }
}
