<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CI_Citation_Type StructType
 * @subpackage Structs
 */
class CI_Citation_Type extends AbstractStructBase
{
    /**
     * The title
     * @var \StructType\CharacterString_PropertyType
     */
    public $title;
    /**
     * The alternateTitle
     * @var \StructType\CharacterString_PropertyType
     */
    public $alternateTitle;
    /**
     * The date
     * @var \StructType\CI_Date_PropertyType
     */
    public $date;
    /**
     * The edition
     * @var \StructType\CharacterString_PropertyType
     */
    public $edition;
    /**
     * The editionDate
     * @var \StructType\Date_PropertyType
     */
    public $editionDate;
    /**
     * The identifier
     * @var \StructType\MD_Identifier_PropertyType
     */
    public $identifier;
    /**
     * The citedResponsibleParty
     * @var \StructType\CI_ResponsibleParty_PropertyType
     */
    public $citedResponsibleParty;
    /**
     * The presentationForm
     * @var \StructType\CI_PresentationFormCode_PropertyType
     */
    public $presentationForm;
    /**
     * The series
     * @var \StructType\CI_Series_PropertyType
     */
    public $series;
    /**
     * The otherCitationDetails
     * @var \StructType\CharacterString_PropertyType
     */
    public $otherCitationDetails;
    /**
     * The collectiveTitle
     * @var \StructType\CharacterString_PropertyType
     */
    public $collectiveTitle;
    /**
     * The ISBN
     * @var \StructType\CharacterString_PropertyType
     */
    public $ISBN;
    /**
     * The ISSN
     * @var \StructType\CharacterString_PropertyType
     */
    public $ISSN;
    /**
     * Constructor method for CI_Citation_Type
     * @uses CI_Citation_Type::setTitle()
     * @uses CI_Citation_Type::setAlternateTitle()
     * @uses CI_Citation_Type::setDate()
     * @uses CI_Citation_Type::setEdition()
     * @uses CI_Citation_Type::setEditionDate()
     * @uses CI_Citation_Type::setIdentifier()
     * @uses CI_Citation_Type::setCitedResponsibleParty()
     * @uses CI_Citation_Type::setPresentationForm()
     * @uses CI_Citation_Type::setSeries()
     * @uses CI_Citation_Type::setOtherCitationDetails()
     * @uses CI_Citation_Type::setCollectiveTitle()
     * @uses CI_Citation_Type::setISBN()
     * @uses CI_Citation_Type::setISSN()
     * @param \StructType\CharacterString_PropertyType $title
     * @param \StructType\CharacterString_PropertyType $alternateTitle
     * @param \StructType\CI_Date_PropertyType $date
     * @param \StructType\CharacterString_PropertyType $edition
     * @param \StructType\Date_PropertyType $editionDate
     * @param \StructType\MD_Identifier_PropertyType $identifier
     * @param \StructType\CI_ResponsibleParty_PropertyType $citedResponsibleParty
     * @param \StructType\CI_PresentationFormCode_PropertyType $presentationForm
     * @param \StructType\CI_Series_PropertyType $series
     * @param \StructType\CharacterString_PropertyType $otherCitationDetails
     * @param \StructType\CharacterString_PropertyType $collectiveTitle
     * @param \StructType\CharacterString_PropertyType $iSBN
     * @param \StructType\CharacterString_PropertyType $iSSN
     */
    public function __construct(\StructType\CharacterString_PropertyType $title = null, \StructType\CharacterString_PropertyType $alternateTitle = null, \StructType\CI_Date_PropertyType $date = null, \StructType\CharacterString_PropertyType $edition = null, \StructType\Date_PropertyType $editionDate = null, \StructType\MD_Identifier_PropertyType $identifier = null, \StructType\CI_ResponsibleParty_PropertyType $citedResponsibleParty = null, \StructType\CI_PresentationFormCode_PropertyType $presentationForm = null, \StructType\CI_Series_PropertyType $series = null, \StructType\CharacterString_PropertyType $otherCitationDetails = null, \StructType\CharacterString_PropertyType $collectiveTitle = null, \StructType\CharacterString_PropertyType $iSBN = null, \StructType\CharacterString_PropertyType $iSSN = null)
    {
        $this
            ->setTitle($title)
            ->setAlternateTitle($alternateTitle)
            ->setDate($date)
            ->setEdition($edition)
            ->setEditionDate($editionDate)
            ->setIdentifier($identifier)
            ->setCitedResponsibleParty($citedResponsibleParty)
            ->setPresentationForm($presentationForm)
            ->setSeries($series)
            ->setOtherCitationDetails($otherCitationDetails)
            ->setCollectiveTitle($collectiveTitle)
            ->setISBN($iSBN)
            ->setISSN($iSSN);
    }
    /**
     * Get title value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param \StructType\CharacterString_PropertyType $title
     * @return \StructType\CI_Citation_Type
     */
    public function setTitle(\StructType\CharacterString_PropertyType $title = null)
    {
        $this->title = $title;
        return $this;
    }
    /**
     * Get alternateTitle value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getAlternateTitle()
    {
        return $this->alternateTitle;
    }
    /**
     * Set alternateTitle value
     * @param \StructType\CharacterString_PropertyType $alternateTitle
     * @return \StructType\CI_Citation_Type
     */
    public function setAlternateTitle(\StructType\CharacterString_PropertyType $alternateTitle = null)
    {
        $this->alternateTitle = $alternateTitle;
        return $this;
    }
    /**
     * Get date value
     * @return \StructType\CI_Date_PropertyType|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param \StructType\CI_Date_PropertyType $date
     * @return \StructType\CI_Citation_Type
     */
    public function setDate(\StructType\CI_Date_PropertyType $date = null)
    {
        $this->date = $date;
        return $this;
    }
    /**
     * Get edition value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getEdition()
    {
        return $this->edition;
    }
    /**
     * Set edition value
     * @param \StructType\CharacterString_PropertyType $edition
     * @return \StructType\CI_Citation_Type
     */
    public function setEdition(\StructType\CharacterString_PropertyType $edition = null)
    {
        $this->edition = $edition;
        return $this;
    }
    /**
     * Get editionDate value
     * @return \StructType\Date_PropertyType|null
     */
    public function getEditionDate()
    {
        return $this->editionDate;
    }
    /**
     * Set editionDate value
     * @param \StructType\Date_PropertyType $editionDate
     * @return \StructType\CI_Citation_Type
     */
    public function setEditionDate(\StructType\Date_PropertyType $editionDate = null)
    {
        $this->editionDate = $editionDate;
        return $this;
    }
    /**
     * Get identifier value
     * @return \StructType\MD_Identifier_PropertyType|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param \StructType\MD_Identifier_PropertyType $identifier
     * @return \StructType\CI_Citation_Type
     */
    public function setIdentifier(\StructType\MD_Identifier_PropertyType $identifier = null)
    {
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get citedResponsibleParty value
     * @return \StructType\CI_ResponsibleParty_PropertyType|null
     */
    public function getCitedResponsibleParty()
    {
        return $this->citedResponsibleParty;
    }
    /**
     * Set citedResponsibleParty value
     * @param \StructType\CI_ResponsibleParty_PropertyType $citedResponsibleParty
     * @return \StructType\CI_Citation_Type
     */
    public function setCitedResponsibleParty(\StructType\CI_ResponsibleParty_PropertyType $citedResponsibleParty = null)
    {
        $this->citedResponsibleParty = $citedResponsibleParty;
        return $this;
    }
    /**
     * Get presentationForm value
     * @return \StructType\CI_PresentationFormCode_PropertyType|null
     */
    public function getPresentationForm()
    {
        return $this->presentationForm;
    }
    /**
     * Set presentationForm value
     * @param \StructType\CI_PresentationFormCode_PropertyType $presentationForm
     * @return \StructType\CI_Citation_Type
     */
    public function setPresentationForm(\StructType\CI_PresentationFormCode_PropertyType $presentationForm = null)
    {
        $this->presentationForm = $presentationForm;
        return $this;
    }
    /**
     * Get series value
     * @return \StructType\CI_Series_PropertyType|null
     */
    public function getSeries()
    {
        return $this->series;
    }
    /**
     * Set series value
     * @param \StructType\CI_Series_PropertyType $series
     * @return \StructType\CI_Citation_Type
     */
    public function setSeries(\StructType\CI_Series_PropertyType $series = null)
    {
        $this->series = $series;
        return $this;
    }
    /**
     * Get otherCitationDetails value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getOtherCitationDetails()
    {
        return $this->otherCitationDetails;
    }
    /**
     * Set otherCitationDetails value
     * @param \StructType\CharacterString_PropertyType $otherCitationDetails
     * @return \StructType\CI_Citation_Type
     */
    public function setOtherCitationDetails(\StructType\CharacterString_PropertyType $otherCitationDetails = null)
    {
        $this->otherCitationDetails = $otherCitationDetails;
        return $this;
    }
    /**
     * Get collectiveTitle value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getCollectiveTitle()
    {
        return $this->collectiveTitle;
    }
    /**
     * Set collectiveTitle value
     * @param \StructType\CharacterString_PropertyType $collectiveTitle
     * @return \StructType\CI_Citation_Type
     */
    public function setCollectiveTitle(\StructType\CharacterString_PropertyType $collectiveTitle = null)
    {
        $this->collectiveTitle = $collectiveTitle;
        return $this;
    }
    /**
     * Get ISBN value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getISBN()
    {
        return $this->ISBN;
    }
    /**
     * Set ISBN value
     * @param \StructType\CharacterString_PropertyType $iSBN
     * @return \StructType\CI_Citation_Type
     */
    public function setISBN(\StructType\CharacterString_PropertyType $iSBN = null)
    {
        $this->ISBN = $iSBN;
        return $this;
    }
    /**
     * Get ISSN value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getISSN()
    {
        return $this->ISSN;
    }
    /**
     * Set ISSN value
     * @param \StructType\CharacterString_PropertyType $iSSN
     * @return \StructType\CI_Citation_Type
     */
    public function setISSN(\StructType\CharacterString_PropertyType $iSSN = null)
    {
        $this->ISSN = $iSSN;
        return $this;
    }
}
