<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoundingShapeType StructType
 * @subpackage Structs
 */
class BoundingShapeType extends AbstractStructBase
{
    /**
     * The Envelope
     * @var \StructType\EnvelopeType
     */
    public $Envelope;
    /**
     * The Null
     * @var string
     */
    public $Null;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for BoundingShapeType
     * @uses BoundingShapeType::setEnvelope()
     * @uses BoundingShapeType::setNull()
     * @uses BoundingShapeType::setNilReason()
     * @param \StructType\EnvelopeType $envelope
     * @param string $null
     * @param string $nilReason
     */
    public function __construct(\StructType\EnvelopeType $envelope = null, $null = null, $nilReason = null)
    {
        $this
            ->setEnvelope($envelope)
            ->setNull($null)
            ->setNilReason($nilReason);
    }
    /**
     * Get Envelope value
     * @return \StructType\EnvelopeType|null
     */
    public function getEnvelope()
    {
        return $this->Envelope;
    }
    /**
     * Set Envelope value
     * @param \StructType\EnvelopeType $envelope
     * @return \StructType\BoundingShapeType
     */
    public function setEnvelope(\StructType\EnvelopeType $envelope = null)
    {
        $this->Envelope = $envelope;
        return $this;
    }
    /**
     * Get Null value
     * @return string|null
     */
    public function getNull()
    {
        return $this->Null;
    }
    /**
     * Set Null value
     * @param string $null
     * @return \StructType\BoundingShapeType
     */
    public function setNull($null = null)
    {
        // validation for constraint: string
        if (!is_null($null) && !is_string($null)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($null, true), gettype($null)), __LINE__);
        }
        $this->Null = $null;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\BoundingShapeType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
