<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Boolean_PropertyType StructType
 * @subpackage Structs
 */
class Boolean_PropertyType extends AbstractStructBase
{
    /**
     * The Boolean
     * @var bool
     */
    public $Boolean;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for Boolean_PropertyType
     * @uses Boolean_PropertyType::setBoolean()
     * @uses Boolean_PropertyType::setNilReason()
     * @param bool $boolean
     * @param string $nilReason
     */
    public function __construct($boolean = null, $nilReason = null)
    {
        $this
            ->setBoolean($boolean)
            ->setNilReason($nilReason);
    }
    /**
     * Get Boolean value
     * @return bool|null
     */
    public function getBoolean()
    {
        return $this->Boolean;
    }
    /**
     * Set Boolean value
     * @param bool $boolean
     * @return \StructType\Boolean_PropertyType
     */
    public function setBoolean($boolean = null)
    {
        // validation for constraint: boolean
        if (!is_null($boolean) && !is_bool($boolean)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($boolean, true), gettype($boolean)), __LINE__);
        }
        $this->Boolean = $boolean;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\Boolean_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
