<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BinaryObject StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp für Binärobjekte, welche Base64-enkodiert werden.Orientiert sich am UN/CEFACT Datentyp BinaryObject.
 * @subpackage Structs
 */
class BinaryObject extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The characterSetCode
     * Meta information extracted from the WSDL
     * - documentation: Zeichensatz des Binärobjekts, falls MIME Type Text.
     * - use: optional
     * @var string
     */
    public $characterSetCode;
    /**
     * The encodingCode
     * Meta information extracted from the WSDL
     * - documentation: Spezifiziert den Dekodierungsalgorithmus des Binärobjekts.
     * - use: optional
     * @var string
     */
    public $encodingCode;
    /**
     * The filename
     * Meta information extracted from the WSDL
     * - documentation: Dateiname des Binärobjekts.
     * - use: optional
     * @var string
     */
    public $filename;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - documentation: Format des Binärobjekts.
     * - use: optional
     * @var string
     */
    public $format;
    /**
     * The mimeCode
     * Meta information extracted from the WSDL
     * - documentation: MIME Type des Binärobjekts.
     * - use: optional
     * @var string
     */
    public $mimeCode;
    /**
     * The uri
     * Meta information extracted from the WSDL
     * - documentation: URI auf das Binärobjekt.
     * - use: optional
     * @var string
     */
    public $uri;
    /**
     * Constructor method for BinaryObject
     * @uses BinaryObject::set_()
     * @uses BinaryObject::setCharacterSetCode()
     * @uses BinaryObject::setEncodingCode()
     * @uses BinaryObject::setFilename()
     * @uses BinaryObject::setFormat()
     * @uses BinaryObject::setMimeCode()
     * @uses BinaryObject::setUri()
     * @param string $_
     * @param string $characterSetCode
     * @param string $encodingCode
     * @param string $filename
     * @param string $format
     * @param string $mimeCode
     * @param string $uri
     */
    public function __construct($_ = null, $characterSetCode = null, $encodingCode = null, $filename = null, $format = null, $mimeCode = null, $uri = null)
    {
        $this
            ->set_($_)
            ->setCharacterSetCode($characterSetCode)
            ->setEncodingCode($encodingCode)
            ->setFilename($filename)
            ->setFormat($format)
            ->setMimeCode($mimeCode)
            ->setUri($uri);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\BinaryObject
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get characterSetCode value
     * @return string|null
     */
    public function getCharacterSetCode()
    {
        return $this->characterSetCode;
    }
    /**
     * Set characterSetCode value
     * @param string $characterSetCode
     * @return \StructType\BinaryObject
     */
    public function setCharacterSetCode($characterSetCode = null)
    {
        // validation for constraint: string
        if (!is_null($characterSetCode) && !is_string($characterSetCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($characterSetCode, true), gettype($characterSetCode)), __LINE__);
        }
        $this->characterSetCode = $characterSetCode;
        return $this;
    }
    /**
     * Get encodingCode value
     * @return string|null
     */
    public function getEncodingCode()
    {
        return $this->encodingCode;
    }
    /**
     * Set encodingCode value
     * @param string $encodingCode
     * @return \StructType\BinaryObject
     */
    public function setEncodingCode($encodingCode = null)
    {
        // validation for constraint: string
        if (!is_null($encodingCode) && !is_string($encodingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encodingCode, true), gettype($encodingCode)), __LINE__);
        }
        $this->encodingCode = $encodingCode;
        return $this;
    }
    /**
     * Get filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\BinaryObject
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \StructType\BinaryObject
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get mimeCode value
     * @return string|null
     */
    public function getMimeCode()
    {
        return $this->mimeCode;
    }
    /**
     * Set mimeCode value
     * @param string $mimeCode
     * @return \StructType\BinaryObject
     */
    public function setMimeCode($mimeCode = null)
    {
        // validation for constraint: string
        if (!is_null($mimeCode) && !is_string($mimeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeCode, true), gettype($mimeCode)), __LINE__);
        }
        $this->mimeCode = $mimeCode;
        return $this;
    }
    /**
     * Get uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->uri;
    }
    /**
     * Set uri value
     * @param string $uri
     * @return \StructType\BinaryObject
     */
    public function setUri($uri = null)
    {
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uri, true), gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }
}
