<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BegriffImKontext StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Begriff im Kontext besteht aus dem eigentlichen Begriff sowie einem optionalen Typ.
 * @subpackage Structs
 */
class BegriffImKontext extends AbstractStructBase
{
    /**
     * The begriff
     * Meta information extracted from the WSDL
     * - documentation: Der eigentliche Begriff ist ein Wort oder eine Wortgruppe.
     * @var \StructType\String_Localized
     */
    public $begriff;
    /**
     * The typ
     * Meta information extracted from the WSDL
     * - documentation: Optionale Angabe zum Typ des Begriffs.
     * - minOccurs: 0
     * @var \StructType\Code_BegriffImKontextTyp
     */
    public $typ;
    /**
     * Constructor method for BegriffImKontext
     * @uses BegriffImKontext::setBegriff()
     * @uses BegriffImKontext::setTyp()
     * @param \StructType\String_Localized $begriff
     * @param \StructType\Code_BegriffImKontextTyp $typ
     */
    public function __construct(\StructType\String_Localized $begriff = null, \StructType\Code_BegriffImKontextTyp $typ = null)
    {
        $this
            ->setBegriff($begriff)
            ->setTyp($typ);
    }
    /**
     * Get begriff value
     * @return \StructType\String_Localized|null
     */
    public function getBegriff()
    {
        return $this->begriff;
    }
    /**
     * Set begriff value
     * @param \StructType\String_Localized $begriff
     * @return \StructType\BegriffImKontext
     */
    public function setBegriff(\StructType\String_Localized $begriff = null)
    {
        $this->begriff = $begriff;
        return $this;
    }
    /**
     * Get typ value
     * @return \StructType\Code_BegriffImKontextTyp|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @param \StructType\Code_BegriffImKontextTyp $typ
     * @return \StructType\BegriffImKontext
     */
    public function setTyp(\StructType\Code_BegriffImKontextTyp $typ = null)
    {
        $this->typ = $typ;
        return $this;
    }
}
