<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bearbeitungsdauermodul StructType
 * Meta information extracted from the WSDL
 * - documentation: Modul zur Angabe von Bearbeitungsdauer von Leistungen.
 * @subpackage Structs
 */
class Bearbeitungsdauermodul extends Leistungsmodul
{
    /**
     * The bearbeitungsdauer
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Bearbeitungsdauer. Es werden die Datentypen für Fristen genutzt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FristOhneTyp[]
     */
    public $bearbeitungsdauer;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Textuelle Erläuterungen zur Bearbeitungsdauer.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The weiterfuehrenderLink
     * Meta information extracted from the WSDL
     * - documentation: Angabe von weiterführende Links.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HyperlinkErweitert[]
     */
    public $weiterfuehrenderLink;
    /**
     * Constructor method for Bearbeitungsdauermodul
     * @uses Bearbeitungsdauermodul::setBearbeitungsdauer()
     * @uses Bearbeitungsdauermodul::setBeschreibung()
     * @uses Bearbeitungsdauermodul::setWeiterfuehrenderLink()
     * @param \StructType\FristOhneTyp[] $bearbeitungsdauer
     * @param \StructType\String_Localized[] $beschreibung
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     */
    public function __construct(array $bearbeitungsdauer = array(), array $beschreibung = array(), array $weiterfuehrenderLink = array())
    {
        $this
            ->setBearbeitungsdauer($bearbeitungsdauer)
            ->setBeschreibung($beschreibung)
            ->setWeiterfuehrenderLink($weiterfuehrenderLink);
    }
    /**
     * Get bearbeitungsdauer value
     * @return \StructType\FristOhneTyp[]|null
     */
    public function getBearbeitungsdauer()
    {
        return $this->bearbeitungsdauer;
    }
    /**
     * This method is responsible for validating the values passed to the setBearbeitungsdauer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBearbeitungsdauer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBearbeitungsdauerForArrayConstraintsFromSetBearbeitungsdauer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bearbeitungsdauermodulBearbeitungsdauerItem) {
            // validation for constraint: itemType
            if (!$bearbeitungsdauermodulBearbeitungsdauerItem instanceof \StructType\FristOhneTyp) {
                $invalidValues[] = is_object($bearbeitungsdauermodulBearbeitungsdauerItem) ? get_class($bearbeitungsdauermodulBearbeitungsdauerItem) : sprintf('%s(%s)', gettype($bearbeitungsdauermodulBearbeitungsdauerItem), var_export($bearbeitungsdauermodulBearbeitungsdauerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bearbeitungsdauer property can only contain items of type \StructType\FristOhneTyp, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bearbeitungsdauer value
     * @throws \InvalidArgumentException
     * @param \StructType\FristOhneTyp[] $bearbeitungsdauer
     * @return \StructType\Bearbeitungsdauermodul
     */
    public function setBearbeitungsdauer(array $bearbeitungsdauer = array())
    {
        // validation for constraint: array
        if ('' !== ($bearbeitungsdauerArrayErrorMessage = self::validateBearbeitungsdauerForArrayConstraintsFromSetBearbeitungsdauer($bearbeitungsdauer))) {
            throw new \InvalidArgumentException($bearbeitungsdauerArrayErrorMessage, __LINE__);
        }
        $this->bearbeitungsdauer = $bearbeitungsdauer;
        return $this;
    }
    /**
     * Add item to bearbeitungsdauer value
     * @throws \InvalidArgumentException
     * @param \StructType\FristOhneTyp $item
     * @return \StructType\Bearbeitungsdauermodul
     */
    public function addToBearbeitungsdauer(\StructType\FristOhneTyp $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FristOhneTyp) {
            throw new \InvalidArgumentException(sprintf('The bearbeitungsdauer property can only contain items of type \StructType\FristOhneTyp, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bearbeitungsdauer[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bearbeitungsdauermodulBeschreibungItem) {
            // validation for constraint: itemType
            if (!$bearbeitungsdauermodulBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($bearbeitungsdauermodulBeschreibungItem) ? get_class($bearbeitungsdauermodulBeschreibungItem) : sprintf('%s(%s)', gettype($bearbeitungsdauermodulBeschreibungItem), var_export($bearbeitungsdauermodulBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Bearbeitungsdauermodul
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Bearbeitungsdauermodul
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get weiterfuehrenderLink value
     * @return \StructType\HyperlinkErweitert[]|null
     */
    public function getWeiterfuehrenderLink()
    {
        return $this->weiterfuehrenderLink;
    }
    /**
     * This method is responsible for validating the values passed to the setWeiterfuehrenderLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeiterfuehrenderLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bearbeitungsdauermodulWeiterfuehrenderLinkItem) {
            // validation for constraint: itemType
            if (!$bearbeitungsdauermodulWeiterfuehrenderLinkItem instanceof \StructType\HyperlinkErweitert) {
                $invalidValues[] = is_object($bearbeitungsdauermodulWeiterfuehrenderLinkItem) ? get_class($bearbeitungsdauermodulWeiterfuehrenderLinkItem) : sprintf('%s(%s)', gettype($bearbeitungsdauermodulWeiterfuehrenderLinkItem), var_export($bearbeitungsdauermodulWeiterfuehrenderLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     * @return \StructType\Bearbeitungsdauermodul
     */
    public function setWeiterfuehrenderLink(array $weiterfuehrenderLink = array())
    {
        // validation for constraint: array
        if ('' !== ($weiterfuehrenderLinkArrayErrorMessage = self::validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink($weiterfuehrenderLink))) {
            throw new \InvalidArgumentException($weiterfuehrenderLinkArrayErrorMessage, __LINE__);
        }
        $this->weiterfuehrenderLink = $weiterfuehrenderLink;
        return $this;
    }
    /**
     * Add item to weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert $item
     * @return \StructType\Bearbeitungsdauermodul
     */
    public function addToWeiterfuehrenderLink(\StructType\HyperlinkErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HyperlinkErweitert) {
            throw new \InvalidArgumentException(sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weiterfuehrenderLink[] = $item;
        return $this;
    }
}
