<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Basisnachricht StructType
 * Meta information extracted from the WSDL
 * - documentation: Basisklasse für Nachrichten. Enthält grundlegende Metainformationen zur Nachricht.
 * @subpackage Structs
 */
abstract class Basisnachricht extends AbstractStructBase
{
    /**
     * The produktbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung des Produkts, welche die XZuFi-Schnittstelle implementiert.
     * - use: required
     * @var string
     */
    public $produktbezeichnung;
    /**
     * The produkthersteller
     * Meta information extracted from the WSDL
     * - documentation: Name des Produktherstellers. Hersteller des Produkts, welcher die XZuFi-Schnittstelle implementiert.
     * - use: required
     * @var string
     */
    public $produkthersteller;
    /**
     * The xzufiVersion
     * Meta information extracted from the WSDL
     * - documentation: Versionsnummer der verwendeten XZuFi-Version, z.B. "1.0"
     * - use: required
     * @var string
     */
    public $xzufiVersion;
    /**
     * The nachrichtenkopf
     * Meta information extracted from the WSDL
     * - documentation: Nachrichtenkopf
     * @var \StructType\Nachrichtenkopf
     */
    public $nachrichtenkopf;
    /**
     * The produktversion
     * Meta information extracted from the WSDL
     * - documentation: Versionsnummer des Produkts, welches XZuFi implementiert.
     * - use: optional
     * @var string
     */
    public $produktversion;
    /**
     * Constructor method for Basisnachricht
     * @uses Basisnachricht::setProduktbezeichnung()
     * @uses Basisnachricht::setProdukthersteller()
     * @uses Basisnachricht::setXzufiVersion()
     * @uses Basisnachricht::setNachrichtenkopf()
     * @uses Basisnachricht::setProduktversion()
     * @param string $produktbezeichnung
     * @param string $produkthersteller
     * @param string $xzufiVersion
     * @param \StructType\Nachrichtenkopf $nachrichtenkopf
     * @param string $produktversion
     */
    public function __construct($produktbezeichnung = null, $produkthersteller = null, $xzufiVersion = null, \StructType\Nachrichtenkopf $nachrichtenkopf = null, $produktversion = null)
    {
        $this
            ->setProduktbezeichnung($produktbezeichnung)
            ->setProdukthersteller($produkthersteller)
            ->setXzufiVersion($xzufiVersion)
            ->setNachrichtenkopf($nachrichtenkopf)
            ->setProduktversion($produktversion);
    }
    /**
     * Get produktbezeichnung value
     * @return string
     */
    public function getProduktbezeichnung()
    {
        return $this->produktbezeichnung;
    }
    /**
     * Set produktbezeichnung value
     * @param string $produktbezeichnung
     * @return \StructType\Basisnachricht
     */
    public function setProduktbezeichnung($produktbezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($produktbezeichnung) && !is_string($produktbezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($produktbezeichnung, true), gettype($produktbezeichnung)), __LINE__);
        }
        $this->produktbezeichnung = $produktbezeichnung;
        return $this;
    }
    /**
     * Get produkthersteller value
     * @return string
     */
    public function getProdukthersteller()
    {
        return $this->produkthersteller;
    }
    /**
     * Set produkthersteller value
     * @param string $produkthersteller
     * @return \StructType\Basisnachricht
     */
    public function setProdukthersteller($produkthersteller = null)
    {
        // validation for constraint: string
        if (!is_null($produkthersteller) && !is_string($produkthersteller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($produkthersteller, true), gettype($produkthersteller)), __LINE__);
        }
        $this->produkthersteller = $produkthersteller;
        return $this;
    }
    /**
     * Get xzufiVersion value
     * @return string
     */
    public function getXzufiVersion()
    {
        return $this->xzufiVersion;
    }
    /**
     * Set xzufiVersion value
     * @param string $xzufiVersion
     * @return \StructType\Basisnachricht
     */
    public function setXzufiVersion($xzufiVersion = null)
    {
        // validation for constraint: string
        if (!is_null($xzufiVersion) && !is_string($xzufiVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xzufiVersion, true), gettype($xzufiVersion)), __LINE__);
        }
        $this->xzufiVersion = $xzufiVersion;
        return $this;
    }
    /**
     * Get nachrichtenkopf value
     * @return \StructType\Nachrichtenkopf|null
     */
    public function getNachrichtenkopf()
    {
        return $this->nachrichtenkopf;
    }
    /**
     * Set nachrichtenkopf value
     * @param \StructType\Nachrichtenkopf $nachrichtenkopf
     * @return \StructType\Basisnachricht
     */
    public function setNachrichtenkopf(\StructType\Nachrichtenkopf $nachrichtenkopf = null)
    {
        $this->nachrichtenkopf = $nachrichtenkopf;
        return $this;
    }
    /**
     * Get produktversion value
     * @return string|null
     */
    public function getProduktversion()
    {
        return $this->produktversion;
    }
    /**
     * Set produktversion value
     * @param string $produktversion
     * @return \StructType\Basisnachricht
     */
    public function setProduktversion($produktversion = null)
    {
        // validation for constraint: string
        if (!is_null($produktversion) && !is_string($produktversion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($produktversion, true), gettype($produktversion)), __LINE__);
        }
        $this->produktversion = $produktversion;
        return $this;
    }
}
