<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuswahlOrganisationseinheitBasisinformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Ergebnis einer Organisationseinheitsbafrage. Enthält entweder die Organisationseinheiten oder die Basisinformationsobjekte zu Organisationseinheiten.
 * @subpackage Structs
 */
class AuswahlOrganisationseinheitBasisinformation extends AbstractStructBase
{
    /**
     * The organisationseinheit
     * Meta information extracted from the WSDL
     * - documentation: Menge von OEs. Hier wird je nach Wahl im Suchprofil entweder Organisationseinheit oder OrganisationseinheitErweitert übertragen.
     * - choice: organisationseinheit | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Organisationseinheit[]
     */
    public $organisationseinheit;
    /**
     * The basisinformation
     * Meta information extracted from the WSDL
     * - documentation: Menge von Basisinformationen zu OEs.
     * - choice: organisationseinheit | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BasisinformationObjekt[]
     */
    public $basisinformation;
    /**
     * Constructor method for AuswahlOrganisationseinheitBasisinformation
     * @uses AuswahlOrganisationseinheitBasisinformation::setOrganisationseinheit()
     * @uses AuswahlOrganisationseinheitBasisinformation::setBasisinformation()
     * @param \StructType\Organisationseinheit[] $organisationseinheit
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     */
    public function __construct(array $organisationseinheit = array(), array $basisinformation = array())
    {
        $this
            ->setOrganisationseinheit($organisationseinheit)
            ->setBasisinformation($basisinformation);
    }
    /**
     * Get organisationseinheit value
     * @return \StructType\Organisationseinheit[]|null
     */
    public function getOrganisationseinheit()
    {
        return isset($this->organisationseinheit) ? $this->organisationseinheit : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganisationseinheit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganisationseinheit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganisationseinheitForArrayConstraintsFromSetOrganisationseinheit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlOrganisationseinheitBasisinformationOrganisationseinheitItem) {
            // validation for constraint: itemType
            if (!$auswahlOrganisationseinheitBasisinformationOrganisationseinheitItem instanceof \StructType\Organisationseinheit) {
                $invalidValues[] = is_object($auswahlOrganisationseinheitBasisinformationOrganisationseinheitItem) ? get_class($auswahlOrganisationseinheitBasisinformationOrganisationseinheitItem) : sprintf('%s(%s)', gettype($auswahlOrganisationseinheitBasisinformationOrganisationseinheitItem), var_export($auswahlOrganisationseinheitBasisinformationOrganisationseinheitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The organisationseinheit property can only contain items of type \StructType\Organisationseinheit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setOrganisationseinheit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganisationseinheit method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrganisationseinheitForChoiceConstraintsFromSetOrganisationseinheit($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property organisationseinheit can\'t be set as the property %s is already set. Only one property must be set among these properties: organisationseinheit, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set organisationseinheit value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Organisationseinheit[] $organisationseinheit
     * @return \StructType\AuswahlOrganisationseinheitBasisinformation
     */
    public function setOrganisationseinheit(array $organisationseinheit = array())
    {
        // validation for constraint: array
        if ('' !== ($organisationseinheitArrayErrorMessage = self::validateOrganisationseinheitForArrayConstraintsFromSetOrganisationseinheit($organisationseinheit))) {
            throw new \InvalidArgumentException($organisationseinheitArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(organisationseinheit, basisinformation)
        if ('' !== ($organisationseinheitChoiceErrorMessage = self::validateOrganisationseinheitForChoiceConstraintsFromSetOrganisationseinheit($organisationseinheit))) {
            throw new \InvalidArgumentException($organisationseinheitChoiceErrorMessage, __LINE__);
        }
        if (is_null($organisationseinheit) || (is_array($organisationseinheit) && empty($organisationseinheit))) {
            unset($this->organisationseinheit);
        } else {
            $this->organisationseinheit = $organisationseinheit;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToOrganisationseinheit method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToOrganisationseinheit method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToOrganisationseinheit($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property organisationseinheit can\'t be set as the property %s is already set. Only one property must be set among these properties: organisationseinheit, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to organisationseinheit value
     * @throws \InvalidArgumentException
     * @param \StructType\Organisationseinheit $item
     * @return \StructType\AuswahlOrganisationseinheitBasisinformation
     */
    public function addToOrganisationseinheit(\StructType\Organisationseinheit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Organisationseinheit) {
            throw new \InvalidArgumentException(sprintf('The organisationseinheit property can only contain items of type \StructType\Organisationseinheit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(organisationseinheit, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToOrganisationseinheit($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->organisationseinheit[] = $item;
        return $this;
    }
    /**
     * Get basisinformation value
     * @return \StructType\BasisinformationObjekt[]|null
     */
    public function getBasisinformation()
    {
        return isset($this->basisinformation) ? $this->basisinformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBasisinformationForArrayConstraintsFromSetBasisinformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlOrganisationseinheitBasisinformationBasisinformationItem) {
            // validation for constraint: itemType
            if (!$auswahlOrganisationseinheitBasisinformationBasisinformationItem instanceof \StructType\BasisinformationObjekt) {
                $invalidValues[] = is_object($auswahlOrganisationseinheitBasisinformationBasisinformationItem) ? get_class($auswahlOrganisationseinheitBasisinformationBasisinformationItem) : sprintf('%s(%s)', gettype($auswahlOrganisationseinheitBasisinformationBasisinformationItem), var_export($auswahlOrganisationseinheitBasisinformationBasisinformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBasisinformationForChoiceConstraintsFromSetBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'organisationseinheit',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set basisinformation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     * @return \StructType\AuswahlOrganisationseinheitBasisinformation
     */
    public function setBasisinformation(array $basisinformation = array())
    {
        // validation for constraint: array
        if ('' !== ($basisinformationArrayErrorMessage = self::validateBasisinformationForArrayConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(organisationseinheit, basisinformation)
        if ('' !== ($basisinformationChoiceErrorMessage = self::validateBasisinformationForChoiceConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationChoiceErrorMessage, __LINE__);
        }
        if (is_null($basisinformation) || (is_array($basisinformation) && empty($basisinformation))) {
            unset($this->basisinformation);
        } else {
            $this->basisinformation = $basisinformation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'organisationseinheit',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to basisinformation value
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt $item
     * @return \StructType\AuswahlOrganisationseinheitBasisinformation
     */
    public function addToBasisinformation(\StructType\BasisinformationObjekt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BasisinformationObjekt) {
            throw new \InvalidArgumentException(sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(organisationseinheit, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToBasisinformation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->basisinformation[] = $item;
        return $this;
    }
}
