<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuswahlOnlinedienstBasisinformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Ergebnis einer Anfrage nach Onlinediensten. Enthält entweder die Onlinedienste oder die Basisinformationsobjekte.
 * @subpackage Structs
 */
class AuswahlOnlinedienstBasisinformation extends AbstractStructBase
{
    /**
     * The onlinedienst
     * Meta information extracted from the WSDL
     * - documentation: Liste von Onlinediensten. Es kann hier auch der Datentyp OnlinedienstErweitert zur Übertragung von Zuständigkeiten angegeben werden.
     * - choice: onlinedienst | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Onlinedienst[]
     */
    public $onlinedienst;
    /**
     * The basisinformation
     * Meta information extracted from the WSDL
     * - documentation: Liste von Basisinformationen zur Onlinediensten.
     * - choice: onlinedienst | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BasisinformationObjekt[]
     */
    public $basisinformation;
    /**
     * Constructor method for AuswahlOnlinedienstBasisinformation
     * @uses AuswahlOnlinedienstBasisinformation::setOnlinedienst()
     * @uses AuswahlOnlinedienstBasisinformation::setBasisinformation()
     * @param \StructType\Onlinedienst[] $onlinedienst
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     */
    public function __construct(array $onlinedienst = array(), array $basisinformation = array())
    {
        $this
            ->setOnlinedienst($onlinedienst)
            ->setBasisinformation($basisinformation);
    }
    /**
     * Get onlinedienst value
     * @return \StructType\Onlinedienst[]|null
     */
    public function getOnlinedienst()
    {
        return isset($this->onlinedienst) ? $this->onlinedienst : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOnlinedienst method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOnlinedienst method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOnlinedienstForArrayConstraintsFromSetOnlinedienst(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlOnlinedienstBasisinformationOnlinedienstItem) {
            // validation for constraint: itemType
            if (!$auswahlOnlinedienstBasisinformationOnlinedienstItem instanceof \StructType\Onlinedienst) {
                $invalidValues[] = is_object($auswahlOnlinedienstBasisinformationOnlinedienstItem) ? get_class($auswahlOnlinedienstBasisinformationOnlinedienstItem) : sprintf('%s(%s)', gettype($auswahlOnlinedienstBasisinformationOnlinedienstItem), var_export($auswahlOnlinedienstBasisinformationOnlinedienstItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The onlinedienst property can only contain items of type \StructType\Onlinedienst, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setOnlinedienst method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOnlinedienst method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOnlinedienstForChoiceConstraintsFromSetOnlinedienst($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property onlinedienst can\'t be set as the property %s is already set. Only one property must be set among these properties: onlinedienst, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set onlinedienst value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Onlinedienst[] $onlinedienst
     * @return \StructType\AuswahlOnlinedienstBasisinformation
     */
    public function setOnlinedienst(array $onlinedienst = array())
    {
        // validation for constraint: array
        if ('' !== ($onlinedienstArrayErrorMessage = self::validateOnlinedienstForArrayConstraintsFromSetOnlinedienst($onlinedienst))) {
            throw new \InvalidArgumentException($onlinedienstArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(onlinedienst, basisinformation)
        if ('' !== ($onlinedienstChoiceErrorMessage = self::validateOnlinedienstForChoiceConstraintsFromSetOnlinedienst($onlinedienst))) {
            throw new \InvalidArgumentException($onlinedienstChoiceErrorMessage, __LINE__);
        }
        if (is_null($onlinedienst) || (is_array($onlinedienst) && empty($onlinedienst))) {
            unset($this->onlinedienst);
        } else {
            $this->onlinedienst = $onlinedienst;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToOnlinedienst method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToOnlinedienst method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToOnlinedienst($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property onlinedienst can\'t be set as the property %s is already set. Only one property must be set among these properties: onlinedienst, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to onlinedienst value
     * @throws \InvalidArgumentException
     * @param \StructType\Onlinedienst $item
     * @return \StructType\AuswahlOnlinedienstBasisinformation
     */
    public function addToOnlinedienst(\StructType\Onlinedienst $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Onlinedienst) {
            throw new \InvalidArgumentException(sprintf('The onlinedienst property can only contain items of type \StructType\Onlinedienst, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(onlinedienst, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToOnlinedienst($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->onlinedienst[] = $item;
        return $this;
    }
    /**
     * Get basisinformation value
     * @return \StructType\BasisinformationObjekt[]|null
     */
    public function getBasisinformation()
    {
        return isset($this->basisinformation) ? $this->basisinformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBasisinformationForArrayConstraintsFromSetBasisinformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlOnlinedienstBasisinformationBasisinformationItem) {
            // validation for constraint: itemType
            if (!$auswahlOnlinedienstBasisinformationBasisinformationItem instanceof \StructType\BasisinformationObjekt) {
                $invalidValues[] = is_object($auswahlOnlinedienstBasisinformationBasisinformationItem) ? get_class($auswahlOnlinedienstBasisinformationBasisinformationItem) : sprintf('%s(%s)', gettype($auswahlOnlinedienstBasisinformationBasisinformationItem), var_export($auswahlOnlinedienstBasisinformationBasisinformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBasisinformationForChoiceConstraintsFromSetBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'onlinedienst',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set basisinformation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     * @return \StructType\AuswahlOnlinedienstBasisinformation
     */
    public function setBasisinformation(array $basisinformation = array())
    {
        // validation for constraint: array
        if ('' !== ($basisinformationArrayErrorMessage = self::validateBasisinformationForArrayConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(onlinedienst, basisinformation)
        if ('' !== ($basisinformationChoiceErrorMessage = self::validateBasisinformationForChoiceConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationChoiceErrorMessage, __LINE__);
        }
        if (is_null($basisinformation) || (is_array($basisinformation) && empty($basisinformation))) {
            unset($this->basisinformation);
        } else {
            $this->basisinformation = $basisinformation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'onlinedienst',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to basisinformation value
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt $item
     * @return \StructType\AuswahlOnlinedienstBasisinformation
     */
    public function addToBasisinformation(\StructType\BasisinformationObjekt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BasisinformationObjekt) {
            throw new \InvalidArgumentException(sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(onlinedienst, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToBasisinformation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->basisinformation[] = $item;
        return $this;
    }
}
