<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortOnlinedienst StructType
 * Meta information extracted from the WSDL
 * - documentation: Antwort zu einer Onlinedienstanfrage.
 * @subpackage Structs
 */
class AntwortOnlinedienst extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Gestellte Anfrage zur Referenz.
     * @var \StructType\AnfrageOnlinedienst
     */
    public $anfrage;
    /**
     * The ergebnis
     * Meta information extracted from the WSDL
     * - documentation: Die Onlinedienste als Ergebnis. Je nach Wahl im Suchprofil als Onlinedienst/OnlinedienstErweitert oder Basisinformation.
     * - minOccurs: 0
     * @var \StructType\AuswahlOnlinedienstBasisinformation
     */
    public $ergebnis;
    /**
     * Constructor method for AntwortOnlinedienst
     * @uses AntwortOnlinedienst::setAnfrage()
     * @uses AntwortOnlinedienst::setErgebnis()
     * @param \StructType\AnfrageOnlinedienst $anfrage
     * @param \StructType\AuswahlOnlinedienstBasisinformation $ergebnis
     */
    public function __construct(\StructType\AnfrageOnlinedienst $anfrage = null, \StructType\AuswahlOnlinedienstBasisinformation $ergebnis = null)
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnis($ergebnis);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageOnlinedienst|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageOnlinedienst $anfrage
     * @return \StructType\AntwortOnlinedienst
     */
    public function setAnfrage(\StructType\AnfrageOnlinedienst $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnis value
     * @return \StructType\AuswahlOnlinedienstBasisinformation|null
     */
    public function getErgebnis()
    {
        return $this->ergebnis;
    }
    /**
     * Set ergebnis value
     * @param \StructType\AuswahlOnlinedienstBasisinformation $ergebnis
     * @return \StructType\AntwortOnlinedienst
     */
    public function setErgebnis(\StructType\AuswahlOnlinedienstBasisinformation $ergebnis = null)
    {
        $this->ergebnis = $ergebnis;
        return $this;
    }
}
