<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortLeistungsbericht StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Leistungsbericht. Dieser enthält die Leistungen und Organisationseinheiten. Für Organisationseinheiten muss der Typ OrganisationseinheitErweitert angegeben werden, welcher auch Zuständigkeiten, Formulare und Kontaktpersonen
 * enthält.Das oder die entsprechenden Gebiete des Berichts können über die Angabe des Suchprofils erfolgen (GebietsIDs). Insbesondere, wenn statische XML-Berichte zur Verfügung gestellt werden.
 * @subpackage Structs
 */
class AntwortLeistungsbericht extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Die gestellte bzw angewandte Anfrage zur Referenz.
     * @var \StructType\AnfrageLeistungsbericht
     */
    public $anfrage;
    /**
     * The ergebnisLeistung
     * Meta information extracted from the WSDL
     * - documentation: Die Leistungen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Leistung[]
     */
    public $ergebnisLeistung;
    /**
     * The ergebnisOrganisationseinheit
     * Meta information extracted from the WSDL
     * - documentation: Die Organisationseinheiten, welche für die unter ergebnisLeistung Zuständigkeiten besitzen. Da hier für Organisationseinheiten der erweiterte Datentyp verwendet wird, können auch alle Zuständigkeiten, Kontaktpersonen sowie
     * Formulare übermittelt werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganisationseinheitErweitert[]
     */
    public $ergebnisOrganisationseinheit;
    /**
     * The ergebnisOnlinedienst
     * Meta information extracted from the WSDL
     * - documentation: Die Onlinedienste, welche für die unter ergebnisLeistung Zuständigkeiten besitzen. Da hier für Onlinedienste der erweiterte Datentyp verwendet wird, können auch Zuständigkeiten übermittelt werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OnlinedienstErweitert[]
     */
    public $ergebnisOnlinedienst;
    /**
     * Constructor method for AntwortLeistungsbericht
     * @uses AntwortLeistungsbericht::setAnfrage()
     * @uses AntwortLeistungsbericht::setErgebnisLeistung()
     * @uses AntwortLeistungsbericht::setErgebnisOrganisationseinheit()
     * @uses AntwortLeistungsbericht::setErgebnisOnlinedienst()
     * @param \StructType\AnfrageLeistungsbericht $anfrage
     * @param \StructType\Leistung[] $ergebnisLeistung
     * @param \StructType\OrganisationseinheitErweitert[] $ergebnisOrganisationseinheit
     * @param \StructType\OnlinedienstErweitert[] $ergebnisOnlinedienst
     */
    public function __construct(\StructType\AnfrageLeistungsbericht $anfrage = null, array $ergebnisLeistung = array(), array $ergebnisOrganisationseinheit = array(), array $ergebnisOnlinedienst = array())
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnisLeistung($ergebnisLeistung)
            ->setErgebnisOrganisationseinheit($ergebnisOrganisationseinheit)
            ->setErgebnisOnlinedienst($ergebnisOnlinedienst);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageLeistungsbericht|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageLeistungsbericht $anfrage
     * @return \StructType\AntwortLeistungsbericht
     */
    public function setAnfrage(\StructType\AnfrageLeistungsbericht $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnisLeistung value
     * @return \StructType\Leistung[]|null
     */
    public function getErgebnisLeistung()
    {
        return $this->ergebnisLeistung;
    }
    /**
     * This method is responsible for validating the values passed to the setErgebnisLeistung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErgebnisLeistung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErgebnisLeistungForArrayConstraintsFromSetErgebnisLeistung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $antwortLeistungsberichtErgebnisLeistungItem) {
            // validation for constraint: itemType
            if (!$antwortLeistungsberichtErgebnisLeistungItem instanceof \StructType\Leistung) {
                $invalidValues[] = is_object($antwortLeistungsberichtErgebnisLeistungItem) ? get_class($antwortLeistungsberichtErgebnisLeistungItem) : sprintf('%s(%s)', gettype($antwortLeistungsberichtErgebnisLeistungItem), var_export($antwortLeistungsberichtErgebnisLeistungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ergebnisLeistung property can only contain items of type \StructType\Leistung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ergebnisLeistung value
     * @throws \InvalidArgumentException
     * @param \StructType\Leistung[] $ergebnisLeistung
     * @return \StructType\AntwortLeistungsbericht
     */
    public function setErgebnisLeistung(array $ergebnisLeistung = array())
    {
        // validation for constraint: array
        if ('' !== ($ergebnisLeistungArrayErrorMessage = self::validateErgebnisLeistungForArrayConstraintsFromSetErgebnisLeistung($ergebnisLeistung))) {
            throw new \InvalidArgumentException($ergebnisLeistungArrayErrorMessage, __LINE__);
        }
        $this->ergebnisLeistung = $ergebnisLeistung;
        return $this;
    }
    /**
     * Add item to ergebnisLeistung value
     * @throws \InvalidArgumentException
     * @param \StructType\Leistung $item
     * @return \StructType\AntwortLeistungsbericht
     */
    public function addToErgebnisLeistung(\StructType\Leistung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Leistung) {
            throw new \InvalidArgumentException(sprintf('The ergebnisLeistung property can only contain items of type \StructType\Leistung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ergebnisLeistung[] = $item;
        return $this;
    }
    /**
     * Get ergebnisOrganisationseinheit value
     * @return \StructType\OrganisationseinheitErweitert[]|null
     */
    public function getErgebnisOrganisationseinheit()
    {
        return $this->ergebnisOrganisationseinheit;
    }
    /**
     * This method is responsible for validating the values passed to the setErgebnisOrganisationseinheit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErgebnisOrganisationseinheit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErgebnisOrganisationseinheitForArrayConstraintsFromSetErgebnisOrganisationseinheit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $antwortLeistungsberichtErgebnisOrganisationseinheitItem) {
            // validation for constraint: itemType
            if (!$antwortLeistungsberichtErgebnisOrganisationseinheitItem instanceof \StructType\OrganisationseinheitErweitert) {
                $invalidValues[] = is_object($antwortLeistungsberichtErgebnisOrganisationseinheitItem) ? get_class($antwortLeistungsberichtErgebnisOrganisationseinheitItem) : sprintf('%s(%s)', gettype($antwortLeistungsberichtErgebnisOrganisationseinheitItem), var_export($antwortLeistungsberichtErgebnisOrganisationseinheitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ergebnisOrganisationseinheit property can only contain items of type \StructType\OrganisationseinheitErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ergebnisOrganisationseinheit value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganisationseinheitErweitert[] $ergebnisOrganisationseinheit
     * @return \StructType\AntwortLeistungsbericht
     */
    public function setErgebnisOrganisationseinheit(array $ergebnisOrganisationseinheit = array())
    {
        // validation for constraint: array
        if ('' !== ($ergebnisOrganisationseinheitArrayErrorMessage = self::validateErgebnisOrganisationseinheitForArrayConstraintsFromSetErgebnisOrganisationseinheit($ergebnisOrganisationseinheit))) {
            throw new \InvalidArgumentException($ergebnisOrganisationseinheitArrayErrorMessage, __LINE__);
        }
        $this->ergebnisOrganisationseinheit = $ergebnisOrganisationseinheit;
        return $this;
    }
    /**
     * Add item to ergebnisOrganisationseinheit value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganisationseinheitErweitert $item
     * @return \StructType\AntwortLeistungsbericht
     */
    public function addToErgebnisOrganisationseinheit(\StructType\OrganisationseinheitErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganisationseinheitErweitert) {
            throw new \InvalidArgumentException(sprintf('The ergebnisOrganisationseinheit property can only contain items of type \StructType\OrganisationseinheitErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ergebnisOrganisationseinheit[] = $item;
        return $this;
    }
    /**
     * Get ergebnisOnlinedienst value
     * @return \StructType\OnlinedienstErweitert[]|null
     */
    public function getErgebnisOnlinedienst()
    {
        return $this->ergebnisOnlinedienst;
    }
    /**
     * This method is responsible for validating the values passed to the setErgebnisOnlinedienst method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErgebnisOnlinedienst method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErgebnisOnlinedienstForArrayConstraintsFromSetErgebnisOnlinedienst(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $antwortLeistungsberichtErgebnisOnlinedienstItem) {
            // validation for constraint: itemType
            if (!$antwortLeistungsberichtErgebnisOnlinedienstItem instanceof \StructType\OnlinedienstErweitert) {
                $invalidValues[] = is_object($antwortLeistungsberichtErgebnisOnlinedienstItem) ? get_class($antwortLeistungsberichtErgebnisOnlinedienstItem) : sprintf('%s(%s)', gettype($antwortLeistungsberichtErgebnisOnlinedienstItem), var_export($antwortLeistungsberichtErgebnisOnlinedienstItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ergebnisOnlinedienst property can only contain items of type \StructType\OnlinedienstErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ergebnisOnlinedienst value
     * @throws \InvalidArgumentException
     * @param \StructType\OnlinedienstErweitert[] $ergebnisOnlinedienst
     * @return \StructType\AntwortLeistungsbericht
     */
    public function setErgebnisOnlinedienst(array $ergebnisOnlinedienst = array())
    {
        // validation for constraint: array
        if ('' !== ($ergebnisOnlinedienstArrayErrorMessage = self::validateErgebnisOnlinedienstForArrayConstraintsFromSetErgebnisOnlinedienst($ergebnisOnlinedienst))) {
            throw new \InvalidArgumentException($ergebnisOnlinedienstArrayErrorMessage, __LINE__);
        }
        $this->ergebnisOnlinedienst = $ergebnisOnlinedienst;
        return $this;
    }
    /**
     * Add item to ergebnisOnlinedienst value
     * @throws \InvalidArgumentException
     * @param \StructType\OnlinedienstErweitert $item
     * @return \StructType\AntwortLeistungsbericht
     */
    public function addToErgebnisOnlinedienst(\StructType\OnlinedienstErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OnlinedienstErweitert) {
            throw new \InvalidArgumentException(sprintf('The ergebnisOnlinedienst property can only contain items of type \StructType\OnlinedienstErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ergebnisOnlinedienst[] = $item;
        return $this;
    }
}
