<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortLeistung StructType
 * Meta information extracted from the WSDL
 * - documentation: Antwort zu einer Leistunganfrage.
 * @subpackage Structs
 */
class AntwortLeistung extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Die gestellte Anfrage zur Referenz.
     * @var \StructType\AnfrageLeistung
     */
    public $anfrage;
    /**
     * The ergebnis
     * Meta information extracted from the WSDL
     * - documentation: Die Leistungen als Ergebnis. Je nach Wahl im Suchprofil als Leistung oder Basisinformation.
     * - minOccurs: 0
     * @var \StructType\AuswahlLeistungBasisinformation
     */
    public $ergebnis;
    /**
     * Constructor method for AntwortLeistung
     * @uses AntwortLeistung::setAnfrage()
     * @uses AntwortLeistung::setErgebnis()
     * @param \StructType\AnfrageLeistung $anfrage
     * @param \StructType\AuswahlLeistungBasisinformation $ergebnis
     */
    public function __construct(\StructType\AnfrageLeistung $anfrage = null, \StructType\AuswahlLeistungBasisinformation $ergebnis = null)
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnis($ergebnis);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageLeistung|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageLeistung $anfrage
     * @return \StructType\AntwortLeistung
     */
    public function setAnfrage(\StructType\AnfrageLeistung $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnis value
     * @return \StructType\AuswahlLeistungBasisinformation|null
     */
    public function getErgebnis()
    {
        return $this->ergebnis;
    }
    /**
     * Set ergebnis value
     * @param \StructType\AuswahlLeistungBasisinformation $ergebnis
     * @return \StructType\AntwortLeistung
     */
    public function setErgebnis(\StructType\AuswahlLeistungBasisinformation $ergebnis = null)
    {
        $this->ergebnis = $ergebnis;
        return $this;
    }
}
