<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortFormular StructType
 * Meta information extracted from the WSDL
 * - documentation: Antwort zu einer Formularanfrage.
 * @subpackage Structs
 */
class AntwortFormular extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Gestellte Anfrage zur Referenz.
     * @var \StructType\AnfrageFormular
     */
    public $anfrage;
    /**
     * The ergebnis
     * Meta information extracted from the WSDL
     * - documentation: Die Formulare als Ergebnis. Je nach Wahl im Suchprofil als Formulare oder Basisinformation.
     * - minOccurs: 0
     * @var \StructType\AuswahlFormularBasisinformation
     */
    public $ergebnis;
    /**
     * Constructor method for AntwortFormular
     * @uses AntwortFormular::setAnfrage()
     * @uses AntwortFormular::setErgebnis()
     * @param \StructType\AnfrageFormular $anfrage
     * @param \StructType\AuswahlFormularBasisinformation $ergebnis
     */
    public function __construct(\StructType\AnfrageFormular $anfrage = null, \StructType\AuswahlFormularBasisinformation $ergebnis = null)
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnis($ergebnis);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageFormular|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageFormular $anfrage
     * @return \StructType\AntwortFormular
     */
    public function setAnfrage(\StructType\AnfrageFormular $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnis value
     * @return \StructType\AuswahlFormularBasisinformation|null
     */
    public function getErgebnis()
    {
        return $this->ergebnis;
    }
    /**
     * Set ergebnis value
     * @param \StructType\AuswahlFormularBasisinformation $ergebnis
     * @return \StructType\AntwortFormular
     */
    public function setErgebnis(\StructType\AuswahlFormularBasisinformation $ergebnis = null)
    {
        $this->ergebnis = $ergebnis;
        return $this;
    }
}
