<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortDatei StructType
 * Meta information extracted from the WSDL
 * - documentation: Antwort zu einer Anfrage nach Dateien.
 * @subpackage Structs
 */
class AntwortDatei extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Die gestellte Anfrage zur Referenz.
     * @var \StructType\AnfrageDatei
     */
    public $anfrage;
    /**
     * The ergebnisDatei
     * Meta information extracted from the WSDL
     * - documentation: Ergebnis der Anfrage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Datei[]
     */
    public $ergebnisDatei;
    /**
     * Constructor method for AntwortDatei
     * @uses AntwortDatei::setAnfrage()
     * @uses AntwortDatei::setErgebnisDatei()
     * @param \StructType\AnfrageDatei $anfrage
     * @param \StructType\Datei[] $ergebnisDatei
     */
    public function __construct(\StructType\AnfrageDatei $anfrage = null, array $ergebnisDatei = array())
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnisDatei($ergebnisDatei);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageDatei|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageDatei $anfrage
     * @return \StructType\AntwortDatei
     */
    public function setAnfrage(\StructType\AnfrageDatei $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnisDatei value
     * @return \StructType\Datei[]|null
     */
    public function getErgebnisDatei()
    {
        return $this->ergebnisDatei;
    }
    /**
     * This method is responsible for validating the values passed to the setErgebnisDatei method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErgebnisDatei method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErgebnisDateiForArrayConstraintsFromSetErgebnisDatei(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $antwortDateiErgebnisDateiItem) {
            // validation for constraint: itemType
            if (!$antwortDateiErgebnisDateiItem instanceof \StructType\Datei) {
                $invalidValues[] = is_object($antwortDateiErgebnisDateiItem) ? get_class($antwortDateiErgebnisDateiItem) : sprintf('%s(%s)', gettype($antwortDateiErgebnisDateiItem), var_export($antwortDateiErgebnisDateiItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ergebnisDatei property can only contain items of type \StructType\Datei, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ergebnisDatei value
     * @throws \InvalidArgumentException
     * @param \StructType\Datei[] $ergebnisDatei
     * @return \StructType\AntwortDatei
     */
    public function setErgebnisDatei(array $ergebnisDatei = array())
    {
        // validation for constraint: array
        if ('' !== ($ergebnisDateiArrayErrorMessage = self::validateErgebnisDateiForArrayConstraintsFromSetErgebnisDatei($ergebnisDatei))) {
            throw new \InvalidArgumentException($ergebnisDateiArrayErrorMessage, __LINE__);
        }
        $this->ergebnisDatei = $ergebnisDatei;
        return $this;
    }
    /**
     * Add item to ergebnisDatei value
     * @throws \InvalidArgumentException
     * @param \StructType\Datei $item
     * @return \StructType\AntwortDatei
     */
    public function addToErgebnisDatei(\StructType\Datei $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Datei) {
            throw new \InvalidArgumentException(sprintf('The ergebnisDatei property can only contain items of type \StructType\Datei, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ergebnisDatei[] = $item;
        return $this;
    }
}
