<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnschriftOrganisationseinheit StructType
 * Meta information extracted from the WSDL
 * - documentation: AnschriftOrganisationseinheit ist von Anschrift abgeleitet und enthält zusätzlich Informationen zur physischen Erreichbarkeit.
 * @subpackage Structs
 */
class AnschriftOrganisationseinheit extends Anschrift
{
    /**
     * The anfahrturl
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete URLs für eine Anfahrtsbeschreibung im Internet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HyperlinkErweitert[]
     */
    public $anfahrturl;
    /**
     * The infoParkplatz
     * Meta information extracted from the WSDL
     * - documentation: Angaben zu Parkplätzen. Diese Information bezieht sich in der Regel auf die Besuchsanschrift der Organisationseinheit.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $infoParkplatz;
    /**
     * The infoOEPNV
     * Meta information extracted from the WSDL
     * - documentation: Angaben zur Erreichbarkeit mit dem ÖPNV. Diese Information bezieht sich in der Regel auf die Besuchsanschrift der Organisationseinheit.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $infoOEPNV;
    /**
     * The infoBarrierefreiheit
     * Meta information extracted from the WSDL
     * - documentation: Angaben zur Barrierefreiheit der OE. Diese Information bezieht sich in der Regel auf die Besuchsanschrift der Organisationseinheit.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $infoBarrierefreiheit;
    /**
     * The kennzeichenAufzug
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob ein Aufzug vorhanden ist. Diese Information bezieht sich in der Regel auf die Besuchsanschrift der Organisationseinheit.
     * - minOccurs: 0
     * @var bool
     */
    public $kennzeichenAufzug;
    /**
     * The kennzeichenRollstuhlgerecht
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob die OE rollstuhlgerecht ist. Diese Information bezieht sich in der Regel auf die Besuchsanschrift der Organisationseinheit.
     * - minOccurs: 0
     * @var bool
     */
    public $kennzeichenRollstuhlgerecht;
    /**
     * Constructor method for AnschriftOrganisationseinheit
     * @uses AnschriftOrganisationseinheit::setAnfahrturl()
     * @uses AnschriftOrganisationseinheit::setInfoParkplatz()
     * @uses AnschriftOrganisationseinheit::setInfoOEPNV()
     * @uses AnschriftOrganisationseinheit::setInfoBarrierefreiheit()
     * @uses AnschriftOrganisationseinheit::setKennzeichenAufzug()
     * @uses AnschriftOrganisationseinheit::setKennzeichenRollstuhlgerecht()
     * @param \StructType\HyperlinkErweitert[] $anfahrturl
     * @param \StructType\String_Localized[] $infoParkplatz
     * @param \StructType\String_Localized[] $infoOEPNV
     * @param \StructType\String_Localized[] $infoBarrierefreiheit
     * @param bool $kennzeichenAufzug
     * @param bool $kennzeichenRollstuhlgerecht
     */
    public function __construct(array $anfahrturl = array(), array $infoParkplatz = array(), array $infoOEPNV = array(), array $infoBarrierefreiheit = array(), $kennzeichenAufzug = null, $kennzeichenRollstuhlgerecht = null)
    {
        $this
            ->setAnfahrturl($anfahrturl)
            ->setInfoParkplatz($infoParkplatz)
            ->setInfoOEPNV($infoOEPNV)
            ->setInfoBarrierefreiheit($infoBarrierefreiheit)
            ->setKennzeichenAufzug($kennzeichenAufzug)
            ->setKennzeichenRollstuhlgerecht($kennzeichenRollstuhlgerecht);
    }
    /**
     * Get anfahrturl value
     * @return \StructType\HyperlinkErweitert[]|null
     */
    public function getAnfahrturl()
    {
        return $this->anfahrturl;
    }
    /**
     * This method is responsible for validating the values passed to the setAnfahrturl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnfahrturl method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnfahrturlForArrayConstraintsFromSetAnfahrturl(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $anschriftOrganisationseinheitAnfahrturlItem) {
            // validation for constraint: itemType
            if (!$anschriftOrganisationseinheitAnfahrturlItem instanceof \StructType\HyperlinkErweitert) {
                $invalidValues[] = is_object($anschriftOrganisationseinheitAnfahrturlItem) ? get_class($anschriftOrganisationseinheitAnfahrturlItem) : sprintf('%s(%s)', gettype($anschriftOrganisationseinheitAnfahrturlItem), var_export($anschriftOrganisationseinheitAnfahrturlItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The anfahrturl property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set anfahrturl value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert[] $anfahrturl
     * @return \StructType\AnschriftOrganisationseinheit
     */
    public function setAnfahrturl(array $anfahrturl = array())
    {
        // validation for constraint: array
        if ('' !== ($anfahrturlArrayErrorMessage = self::validateAnfahrturlForArrayConstraintsFromSetAnfahrturl($anfahrturl))) {
            throw new \InvalidArgumentException($anfahrturlArrayErrorMessage, __LINE__);
        }
        $this->anfahrturl = $anfahrturl;
        return $this;
    }
    /**
     * Add item to anfahrturl value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert $item
     * @return \StructType\AnschriftOrganisationseinheit
     */
    public function addToAnfahrturl(\StructType\HyperlinkErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HyperlinkErweitert) {
            throw new \InvalidArgumentException(sprintf('The anfahrturl property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->anfahrturl[] = $item;
        return $this;
    }
    /**
     * Get infoParkplatz value
     * @return \StructType\String_Localized[]|null
     */
    public function getInfoParkplatz()
    {
        return $this->infoParkplatz;
    }
    /**
     * This method is responsible for validating the values passed to the setInfoParkplatz method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoParkplatz method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoParkplatzForArrayConstraintsFromSetInfoParkplatz(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $anschriftOrganisationseinheitInfoParkplatzItem) {
            // validation for constraint: itemType
            if (!$anschriftOrganisationseinheitInfoParkplatzItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($anschriftOrganisationseinheitInfoParkplatzItem) ? get_class($anschriftOrganisationseinheitInfoParkplatzItem) : sprintf('%s(%s)', gettype($anschriftOrganisationseinheitInfoParkplatzItem), var_export($anschriftOrganisationseinheitInfoParkplatzItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The infoParkplatz property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set infoParkplatz value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $infoParkplatz
     * @return \StructType\AnschriftOrganisationseinheit
     */
    public function setInfoParkplatz(array $infoParkplatz = array())
    {
        // validation for constraint: array
        if ('' !== ($infoParkplatzArrayErrorMessage = self::validateInfoParkplatzForArrayConstraintsFromSetInfoParkplatz($infoParkplatz))) {
            throw new \InvalidArgumentException($infoParkplatzArrayErrorMessage, __LINE__);
        }
        $this->infoParkplatz = $infoParkplatz;
        return $this;
    }
    /**
     * Add item to infoParkplatz value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\AnschriftOrganisationseinheit
     */
    public function addToInfoParkplatz(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The infoParkplatz property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->infoParkplatz[] = $item;
        return $this;
    }
    /**
     * Get infoOEPNV value
     * @return \StructType\String_Localized[]|null
     */
    public function getInfoOEPNV()
    {
        return $this->infoOEPNV;
    }
    /**
     * This method is responsible for validating the values passed to the setInfoOEPNV method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoOEPNV method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoOEPNVForArrayConstraintsFromSetInfoOEPNV(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $anschriftOrganisationseinheitInfoOEPNVItem) {
            // validation for constraint: itemType
            if (!$anschriftOrganisationseinheitInfoOEPNVItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($anschriftOrganisationseinheitInfoOEPNVItem) ? get_class($anschriftOrganisationseinheitInfoOEPNVItem) : sprintf('%s(%s)', gettype($anschriftOrganisationseinheitInfoOEPNVItem), var_export($anschriftOrganisationseinheitInfoOEPNVItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The infoOEPNV property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set infoOEPNV value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $infoOEPNV
     * @return \StructType\AnschriftOrganisationseinheit
     */
    public function setInfoOEPNV(array $infoOEPNV = array())
    {
        // validation for constraint: array
        if ('' !== ($infoOEPNVArrayErrorMessage = self::validateInfoOEPNVForArrayConstraintsFromSetInfoOEPNV($infoOEPNV))) {
            throw new \InvalidArgumentException($infoOEPNVArrayErrorMessage, __LINE__);
        }
        $this->infoOEPNV = $infoOEPNV;
        return $this;
    }
    /**
     * Add item to infoOEPNV value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\AnschriftOrganisationseinheit
     */
    public function addToInfoOEPNV(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The infoOEPNV property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->infoOEPNV[] = $item;
        return $this;
    }
    /**
     * Get infoBarrierefreiheit value
     * @return \StructType\String_Localized[]|null
     */
    public function getInfoBarrierefreiheit()
    {
        return $this->infoBarrierefreiheit;
    }
    /**
     * This method is responsible for validating the values passed to the setInfoBarrierefreiheit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoBarrierefreiheit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoBarrierefreiheitForArrayConstraintsFromSetInfoBarrierefreiheit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $anschriftOrganisationseinheitInfoBarrierefreiheitItem) {
            // validation for constraint: itemType
            if (!$anschriftOrganisationseinheitInfoBarrierefreiheitItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($anschriftOrganisationseinheitInfoBarrierefreiheitItem) ? get_class($anschriftOrganisationseinheitInfoBarrierefreiheitItem) : sprintf('%s(%s)', gettype($anschriftOrganisationseinheitInfoBarrierefreiheitItem), var_export($anschriftOrganisationseinheitInfoBarrierefreiheitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The infoBarrierefreiheit property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set infoBarrierefreiheit value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $infoBarrierefreiheit
     * @return \StructType\AnschriftOrganisationseinheit
     */
    public function setInfoBarrierefreiheit(array $infoBarrierefreiheit = array())
    {
        // validation for constraint: array
        if ('' !== ($infoBarrierefreiheitArrayErrorMessage = self::validateInfoBarrierefreiheitForArrayConstraintsFromSetInfoBarrierefreiheit($infoBarrierefreiheit))) {
            throw new \InvalidArgumentException($infoBarrierefreiheitArrayErrorMessage, __LINE__);
        }
        $this->infoBarrierefreiheit = $infoBarrierefreiheit;
        return $this;
    }
    /**
     * Add item to infoBarrierefreiheit value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\AnschriftOrganisationseinheit
     */
    public function addToInfoBarrierefreiheit(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The infoBarrierefreiheit property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->infoBarrierefreiheit[] = $item;
        return $this;
    }
    /**
     * Get kennzeichenAufzug value
     * @return bool|null
     */
    public function getKennzeichenAufzug()
    {
        return $this->kennzeichenAufzug;
    }
    /**
     * Set kennzeichenAufzug value
     * @param bool $kennzeichenAufzug
     * @return \StructType\AnschriftOrganisationseinheit
     */
    public function setKennzeichenAufzug($kennzeichenAufzug = null)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenAufzug) && !is_bool($kennzeichenAufzug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenAufzug, true), gettype($kennzeichenAufzug)), __LINE__);
        }
        $this->kennzeichenAufzug = $kennzeichenAufzug;
        return $this;
    }
    /**
     * Get kennzeichenRollstuhlgerecht value
     * @return bool|null
     */
    public function getKennzeichenRollstuhlgerecht()
    {
        return $this->kennzeichenRollstuhlgerecht;
    }
    /**
     * Set kennzeichenRollstuhlgerecht value
     * @param bool $kennzeichenRollstuhlgerecht
     * @return \StructType\AnschriftOrganisationseinheit
     */
    public function setKennzeichenRollstuhlgerecht($kennzeichenRollstuhlgerecht = null)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenRollstuhlgerecht) && !is_bool($kennzeichenRollstuhlgerecht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenRollstuhlgerecht, true), gettype($kennzeichenRollstuhlgerecht)), __LINE__);
        }
        $this->kennzeichenRollstuhlgerecht = $kennzeichenRollstuhlgerecht;
        return $this;
    }
}
