<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Anschrift StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine Anschrift umfasst alle Kommunikationsinformationen (z.B. Straße, Wohnort), die für die Zusendung einer Postsendung notwendig sind.
 * @subpackage Structs
 */
class Anschrift extends AbstractStructBase
{
    /**
     * The typ
     * Meta information extracted from the WSDL
     * - documentation: Zugeordneter Typ der Anschrift.
     * - minOccurs: 0
     * @var \StructType\Code_Anschrifttyp
     */
    public $typ;
    /**
     * The strasse
     * Meta information extracted from the WSDL
     * - documentation: Straßenname ohne Hausnummer.
     * - minOccurs: 0
     * @var string
     */
    public $strasse;
    /**
     * The hausnummer
     * Meta information extracted from the WSDL
     * - documentation: Hausnummer der Anschrift.
     * - minOccurs: 0
     * @var string
     */
    public $hausnummer;
    /**
     * The postfach
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung/Nummer des Postfachs der Anschrift.
     * - minOccurs: 0
     * @var string
     */
    public $postfach;
    /**
     * The postleitzahl
     * Meta information extracted from the WSDL
     * - documentation: Postleitzahl der Anschrift.
     * @var string
     */
    public $postleitzahl;
    /**
     * The ort
     * Meta information extracted from the WSDL
     * - documentation: Ort als Freitext wie in Anschrift zu verwenden.
     * @var string
     */
    public $ort;
    /**
     * The ortID
     * Meta information extracted from the WSDL
     * - documentation: Optionale IDs des Ortes (z.B. GebietsID). Es sollen hier nicht verwaltungspolitische Kodierungen, wie z.B. AGS verwendet werden. Hierfür soll das Element verwaltungspolitischeKodierung verwendet werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $ortID;
    /**
     * The verwaltungspolitischeKodierung
     * Meta information extracted from the WSDL
     * - documentation: Die "verwaltungspolitischeKodierung" beinhaltet Informationen, mit denen eine Anschrift verwaltungspolitisch eindeutig zugeordnet werden kann.
     * - minOccurs: 0
     * @var \StructType\VerwaltungspolitischeKodierung
     */
    public $verwaltungspolitischeKodierung;
    /**
     * The zusatz
     * Meta information extracted from the WSDL
     * - documentation: Ein Anschriftenzusatz beinhaltet ggf. erforderliche weitere Präzisierungen zu einer Anschrift.Beispiele: Hinterhof, 3. Aufgang, Haus A, 3. Stock, Appartement 25a, 3. Stock - Appartement 25 a, #325a, Raum 77
     * - minOccurs: 0
     * @var string
     */
    public $zusatz;
    /**
     * The geokodierung
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete geografische Position der Anschrift.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Geokodierung[]
     */
    public $geokodierung;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Optionale Primäre ID.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Anschrift
     * @uses Anschrift::setTyp()
     * @uses Anschrift::setStrasse()
     * @uses Anschrift::setHausnummer()
     * @uses Anschrift::setPostfach()
     * @uses Anschrift::setPostleitzahl()
     * @uses Anschrift::setOrt()
     * @uses Anschrift::setOrtID()
     * @uses Anschrift::setVerwaltungspolitischeKodierung()
     * @uses Anschrift::setZusatz()
     * @uses Anschrift::setGeokodierung()
     * @uses Anschrift::setId()
     * @uses Anschrift::setGueltigkeit()
     * @param \StructType\Code_Anschrifttyp $typ
     * @param string $strasse
     * @param string $hausnummer
     * @param string $postfach
     * @param string $postleitzahl
     * @param string $ort
     * @param \StructType\Identifikator[] $ortID
     * @param \StructType\VerwaltungspolitischeKodierung $verwaltungspolitischeKodierung
     * @param string $zusatz
     * @param \StructType\Geokodierung[] $geokodierung
     * @param \StructType\Identifikator $id
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\Code_Anschrifttyp $typ = null, $strasse = null, $hausnummer = null, $postfach = null, $postleitzahl = null, $ort = null, array $ortID = array(), \StructType\VerwaltungspolitischeKodierung $verwaltungspolitischeKodierung = null, $zusatz = null, array $geokodierung = array(), \StructType\Identifikator $id = null, array $gueltigkeit = array())
    {
        $this
            ->setTyp($typ)
            ->setStrasse($strasse)
            ->setHausnummer($hausnummer)
            ->setPostfach($postfach)
            ->setPostleitzahl($postleitzahl)
            ->setOrt($ort)
            ->setOrtID($ortID)
            ->setVerwaltungspolitischeKodierung($verwaltungspolitischeKodierung)
            ->setZusatz($zusatz)
            ->setGeokodierung($geokodierung)
            ->setId($id)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get typ value
     * @return \StructType\Code_Anschrifttyp|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @param \StructType\Code_Anschrifttyp $typ
     * @return \StructType\Anschrift
     */
    public function setTyp(\StructType\Code_Anschrifttyp $typ = null)
    {
        $this->typ = $typ;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \StructType\Anschrift
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get hausnummer value
     * @return string|null
     */
    public function getHausnummer()
    {
        return $this->hausnummer;
    }
    /**
     * Set hausnummer value
     * @param string $hausnummer
     * @return \StructType\Anschrift
     */
    public function setHausnummer($hausnummer = null)
    {
        // validation for constraint: string
        if (!is_null($hausnummer) && !is_string($hausnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnummer, true), gettype($hausnummer)), __LINE__);
        }
        $this->hausnummer = $hausnummer;
        return $this;
    }
    /**
     * Get postfach value
     * @return string|null
     */
    public function getPostfach()
    {
        return $this->postfach;
    }
    /**
     * Set postfach value
     * @param string $postfach
     * @return \StructType\Anschrift
     */
    public function setPostfach($postfach = null)
    {
        // validation for constraint: string
        if (!is_null($postfach) && !is_string($postfach)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postfach, true), gettype($postfach)), __LINE__);
        }
        $this->postfach = $postfach;
        return $this;
    }
    /**
     * Get postleitzahl value
     * @return string|null
     */
    public function getPostleitzahl()
    {
        return $this->postleitzahl;
    }
    /**
     * Set postleitzahl value
     * @param string $postleitzahl
     * @return \StructType\Anschrift
     */
    public function setPostleitzahl($postleitzahl = null)
    {
        // validation for constraint: string
        if (!is_null($postleitzahl) && !is_string($postleitzahl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postleitzahl, true), gettype($postleitzahl)), __LINE__);
        }
        $this->postleitzahl = $postleitzahl;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\Anschrift
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get ortID value
     * @return \StructType\Identifikator[]|null
     */
    public function getOrtID()
    {
        return $this->ortID;
    }
    /**
     * This method is responsible for validating the values passed to the setOrtID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrtID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrtIDForArrayConstraintsFromSetOrtID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $anschriftOrtIDItem) {
            // validation for constraint: itemType
            if (!$anschriftOrtIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($anschriftOrtIDItem) ? get_class($anschriftOrtIDItem) : sprintf('%s(%s)', gettype($anschriftOrtIDItem), var_export($anschriftOrtIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ortID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ortID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $ortID
     * @return \StructType\Anschrift
     */
    public function setOrtID(array $ortID = array())
    {
        // validation for constraint: array
        if ('' !== ($ortIDArrayErrorMessage = self::validateOrtIDForArrayConstraintsFromSetOrtID($ortID))) {
            throw new \InvalidArgumentException($ortIDArrayErrorMessage, __LINE__);
        }
        $this->ortID = $ortID;
        return $this;
    }
    /**
     * Add item to ortID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Anschrift
     */
    public function addToOrtID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The ortID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ortID[] = $item;
        return $this;
    }
    /**
     * Get verwaltungspolitischeKodierung value
     * @return \StructType\VerwaltungspolitischeKodierung|null
     */
    public function getVerwaltungspolitischeKodierung()
    {
        return $this->verwaltungspolitischeKodierung;
    }
    /**
     * Set verwaltungspolitischeKodierung value
     * @param \StructType\VerwaltungspolitischeKodierung $verwaltungspolitischeKodierung
     * @return \StructType\Anschrift
     */
    public function setVerwaltungspolitischeKodierung(\StructType\VerwaltungspolitischeKodierung $verwaltungspolitischeKodierung = null)
    {
        $this->verwaltungspolitischeKodierung = $verwaltungspolitischeKodierung;
        return $this;
    }
    /**
     * Get zusatz value
     * @return string|null
     */
    public function getZusatz()
    {
        return $this->zusatz;
    }
    /**
     * Set zusatz value
     * @param string $zusatz
     * @return \StructType\Anschrift
     */
    public function setZusatz($zusatz = null)
    {
        // validation for constraint: string
        if (!is_null($zusatz) && !is_string($zusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zusatz, true), gettype($zusatz)), __LINE__);
        }
        $this->zusatz = $zusatz;
        return $this;
    }
    /**
     * Get geokodierung value
     * @return \StructType\Geokodierung[]|null
     */
    public function getGeokodierung()
    {
        return $this->geokodierung;
    }
    /**
     * This method is responsible for validating the values passed to the setGeokodierung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeokodierung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeokodierungForArrayConstraintsFromSetGeokodierung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $anschriftGeokodierungItem) {
            // validation for constraint: itemType
            if (!$anschriftGeokodierungItem instanceof \StructType\Geokodierung) {
                $invalidValues[] = is_object($anschriftGeokodierungItem) ? get_class($anschriftGeokodierungItem) : sprintf('%s(%s)', gettype($anschriftGeokodierungItem), var_export($anschriftGeokodierungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The geokodierung property can only contain items of type \StructType\Geokodierung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set geokodierung value
     * @throws \InvalidArgumentException
     * @param \StructType\Geokodierung[] $geokodierung
     * @return \StructType\Anschrift
     */
    public function setGeokodierung(array $geokodierung = array())
    {
        // validation for constraint: array
        if ('' !== ($geokodierungArrayErrorMessage = self::validateGeokodierungForArrayConstraintsFromSetGeokodierung($geokodierung))) {
            throw new \InvalidArgumentException($geokodierungArrayErrorMessage, __LINE__);
        }
        $this->geokodierung = $geokodierung;
        return $this;
    }
    /**
     * Add item to geokodierung value
     * @throws \InvalidArgumentException
     * @param \StructType\Geokodierung $item
     * @return \StructType\Anschrift
     */
    public function addToGeokodierung(\StructType\Geokodierung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Geokodierung) {
            throw new \InvalidArgumentException(sprintf('The geokodierung property can only contain items of type \StructType\Geokodierung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->geokodierung[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Anschrift
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $anschriftGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$anschriftGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($anschriftGueltigkeitItem) ? get_class($anschriftGueltigkeitItem) : sprintf('%s(%s)', gettype($anschriftGueltigkeitItem), var_export($anschriftGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Anschrift
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Anschrift
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
