<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffinePlacementType StructType
 * @subpackage Structs
 */
class AffinePlacementType extends AbstractStructBase
{
    /**
     * The location
     * @var \StructType\DirectPositionType
     */
    public $location;
    /**
     * The refDirection
     * @var \StructType\VectorType
     */
    public $refDirection;
    /**
     * The inDimension
     * @var int
     */
    public $inDimension;
    /**
     * The outDimension
     * @var int
     */
    public $outDimension;
    /**
     * Constructor method for AffinePlacementType
     * @uses AffinePlacementType::setLocation()
     * @uses AffinePlacementType::setRefDirection()
     * @uses AffinePlacementType::setInDimension()
     * @uses AffinePlacementType::setOutDimension()
     * @param \StructType\DirectPositionType $location
     * @param \StructType\VectorType $refDirection
     * @param int $inDimension
     * @param int $outDimension
     */
    public function __construct(\StructType\DirectPositionType $location = null, \StructType\VectorType $refDirection = null, $inDimension = null, $outDimension = null)
    {
        $this
            ->setLocation($location)
            ->setRefDirection($refDirection)
            ->setInDimension($inDimension)
            ->setOutDimension($outDimension);
    }
    /**
     * Get location value
     * @return \StructType\DirectPositionType|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\DirectPositionType $location
     * @return \StructType\AffinePlacementType
     */
    public function setLocation(\StructType\DirectPositionType $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get refDirection value
     * @return \StructType\VectorType|null
     */
    public function getRefDirection()
    {
        return $this->refDirection;
    }
    /**
     * Set refDirection value
     * @param \StructType\VectorType $refDirection
     * @return \StructType\AffinePlacementType
     */
    public function setRefDirection(\StructType\VectorType $refDirection = null)
    {
        $this->refDirection = $refDirection;
        return $this;
    }
    /**
     * Get inDimension value
     * @return int|null
     */
    public function getInDimension()
    {
        return $this->inDimension;
    }
    /**
     * Set inDimension value
     * @param int $inDimension
     * @return \StructType\AffinePlacementType
     */
    public function setInDimension($inDimension = null)
    {
        // validation for constraint: int
        if (!is_null($inDimension) && !(is_int($inDimension) || ctype_digit($inDimension))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inDimension, true), gettype($inDimension)), __LINE__);
        }
        $this->inDimension = $inDimension;
        return $this;
    }
    /**
     * Get outDimension value
     * @return int|null
     */
    public function getOutDimension()
    {
        return $this->outDimension;
    }
    /**
     * Set outDimension value
     * @param int $outDimension
     * @return \StructType\AffinePlacementType
     */
    public function setOutDimension($outDimension = null)
    {
        // validation for constraint: int
        if (!is_null($outDimension) && !(is_int($outDimension) || ctype_digit($outDimension))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($outDimension, true), gettype($outDimension)), __LINE__);
        }
        $this->outDimension = $outDimension;
        return $this;
    }
}
