<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractGeometryType StructType
 * @subpackage Structs
 */
class AbstractGeometryType extends AbstractStructBase
{
    /**
     * The srsName
     * @var string
     */
    public $srsName;
    /**
     * The srsDimension
     * @var int
     */
    public $srsDimension;
    /**
     * The axisLabels
     * @var list
     */
    public $axisLabels;
    /**
     * The uomLabels
     * @var list
     */
    public $uomLabels;
    /**
     * Constructor method for AbstractGeometryType
     * @uses AbstractGeometryType::setSrsName()
     * @uses AbstractGeometryType::setSrsDimension()
     * @uses AbstractGeometryType::setAxisLabels()
     * @uses AbstractGeometryType::setUomLabels()
     * @param string $srsName
     * @param int $srsDimension
     * @param list $axisLabels
     * @param list $uomLabels
     */
    public function __construct($srsName = null, $srsDimension = null, list $axisLabels = null, list $uomLabels = null)
    {
        $this
            ->setSrsName($srsName)
            ->setSrsDimension($srsDimension)
            ->setAxisLabels($axisLabels)
            ->setUomLabels($uomLabels);
    }
    /**
     * Get srsName value
     * @return string|null
     */
    public function getSrsName()
    {
        return $this->srsName;
    }
    /**
     * Set srsName value
     * @param string $srsName
     * @return \StructType\AbstractGeometryType
     */
    public function setSrsName($srsName = null)
    {
        // validation for constraint: string
        if (!is_null($srsName) && !is_string($srsName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srsName, true), gettype($srsName)), __LINE__);
        }
        $this->srsName = $srsName;
        return $this;
    }
    /**
     * Get srsDimension value
     * @return int|null
     */
    public function getSrsDimension()
    {
        return $this->srsDimension;
    }
    /**
     * Set srsDimension value
     * @param int $srsDimension
     * @return \StructType\AbstractGeometryType
     */
    public function setSrsDimension($srsDimension = null)
    {
        // validation for constraint: int
        if (!is_null($srsDimension) && !(is_int($srsDimension) || ctype_digit($srsDimension))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($srsDimension, true), gettype($srsDimension)), __LINE__);
        }
        $this->srsDimension = $srsDimension;
        return $this;
    }
    /**
     * Get axisLabels value
     * @return list|null
     */
    public function getAxisLabels()
    {
        return $this->axisLabels;
    }
    /**
     * Set axisLabels value
     * @param list $axisLabels
     * @return \StructType\AbstractGeometryType
     */
    public function setAxisLabels(list $axisLabels = null)
    {
        $this->axisLabels = $axisLabels;
        return $this;
    }
    /**
     * Get uomLabels value
     * @return list|null
     */
    public function getUomLabels()
    {
        return $this->uomLabels;
    }
    /**
     * Set uomLabels value
     * @param list $uomLabels
     * @return \StructType\AbstractGeometryType
     */
    public function setUomLabels(list $uomLabels = null)
    {
        $this->uomLabels = $uomLabels;
        return $this;
    }
}
