<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractFeatureType StructType
 * @subpackage Structs
 */
class AbstractFeatureType extends AbstractStructBase
{
    /**
     * The boundedBy
     * @var \StructType\BoundingShapeType
     */
    public $boundedBy;
    /**
     * The location
     * @var \StructType\LocationPropertyType
     */
    public $location;
    /**
     * Constructor method for AbstractFeatureType
     * @uses AbstractFeatureType::setBoundedBy()
     * @uses AbstractFeatureType::setLocation()
     * @param \StructType\BoundingShapeType $boundedBy
     * @param \StructType\LocationPropertyType $location
     */
    public function __construct(\StructType\BoundingShapeType $boundedBy = null, \StructType\LocationPropertyType $location = null)
    {
        $this
            ->setBoundedBy($boundedBy)
            ->setLocation($location);
    }
    /**
     * Get boundedBy value
     * @return \StructType\BoundingShapeType|null
     */
    public function getBoundedBy()
    {
        return $this->boundedBy;
    }
    /**
     * Set boundedBy value
     * @param \StructType\BoundingShapeType $boundedBy
     * @return \StructType\AbstractFeatureType
     */
    public function setBoundedBy(\StructType\BoundingShapeType $boundedBy = null)
    {
        $this->boundedBy = $boundedBy;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\LocationPropertyType|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\LocationPropertyType $location
     * @return \StructType\AbstractFeatureType
     */
    public function setLocation(\StructType\LocationPropertyType $location = null)
    {
        $this->location = $location;
        return $this;
    }
}
