<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractCurveSegmentType StructType
 * @subpackage Structs
 */
class AbstractCurveSegmentType extends AbstractStructBase
{
    /**
     * The numDerivativesAtStart
     * @var int
     */
    public $numDerivativesAtStart;
    /**
     * The numDerivativesAtEnd
     * @var int
     */
    public $numDerivativesAtEnd;
    /**
     * The numDerivativeInterior
     * @var int
     */
    public $numDerivativeInterior;
    /**
     * Constructor method for AbstractCurveSegmentType
     * @uses AbstractCurveSegmentType::setNumDerivativesAtStart()
     * @uses AbstractCurveSegmentType::setNumDerivativesAtEnd()
     * @uses AbstractCurveSegmentType::setNumDerivativeInterior()
     * @param int $numDerivativesAtStart
     * @param int $numDerivativesAtEnd
     * @param int $numDerivativeInterior
     */
    public function __construct($numDerivativesAtStart = null, $numDerivativesAtEnd = null, $numDerivativeInterior = null)
    {
        $this
            ->setNumDerivativesAtStart($numDerivativesAtStart)
            ->setNumDerivativesAtEnd($numDerivativesAtEnd)
            ->setNumDerivativeInterior($numDerivativeInterior);
    }
    /**
     * Get numDerivativesAtStart value
     * @return int|null
     */
    public function getNumDerivativesAtStart()
    {
        return $this->numDerivativesAtStart;
    }
    /**
     * Set numDerivativesAtStart value
     * @param int $numDerivativesAtStart
     * @return \StructType\AbstractCurveSegmentType
     */
    public function setNumDerivativesAtStart($numDerivativesAtStart = null)
    {
        // validation for constraint: int
        if (!is_null($numDerivativesAtStart) && !(is_int($numDerivativesAtStart) || ctype_digit($numDerivativesAtStart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numDerivativesAtStart, true), gettype($numDerivativesAtStart)), __LINE__);
        }
        $this->numDerivativesAtStart = $numDerivativesAtStart;
        return $this;
    }
    /**
     * Get numDerivativesAtEnd value
     * @return int|null
     */
    public function getNumDerivativesAtEnd()
    {
        return $this->numDerivativesAtEnd;
    }
    /**
     * Set numDerivativesAtEnd value
     * @param int $numDerivativesAtEnd
     * @return \StructType\AbstractCurveSegmentType
     */
    public function setNumDerivativesAtEnd($numDerivativesAtEnd = null)
    {
        // validation for constraint: int
        if (!is_null($numDerivativesAtEnd) && !(is_int($numDerivativesAtEnd) || ctype_digit($numDerivativesAtEnd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numDerivativesAtEnd, true), gettype($numDerivativesAtEnd)), __LINE__);
        }
        $this->numDerivativesAtEnd = $numDerivativesAtEnd;
        return $this;
    }
    /**
     * Get numDerivativeInterior value
     * @return int|null
     */
    public function getNumDerivativeInterior()
    {
        return $this->numDerivativeInterior;
    }
    /**
     * Set numDerivativeInterior value
     * @param int $numDerivativeInterior
     * @return \StructType\AbstractCurveSegmentType
     */
    public function setNumDerivativeInterior($numDerivativeInterior = null)
    {
        // validation for constraint: int
        if (!is_null($numDerivativeInterior) && !(is_int($numDerivativeInterior) || ctype_digit($numDerivativeInterior))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numDerivativeInterior, true), gettype($numDerivativeInterior)), __LINE__);
        }
        $this->numDerivativeInterior = $numDerivativeInterior;
        return $this;
    }
}
