<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractCoordinateSystemType StructType
 * @subpackage Structs
 */
class AbstractCoordinateSystemType extends AbstractStructBase
{
    /**
     * The axis
     * @var \StructType\CoordinateSystemAxisPropertyType
     */
    public $axis;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for AbstractCoordinateSystemType
     * @uses AbstractCoordinateSystemType::setAxis()
     * @uses AbstractCoordinateSystemType::setAggregationType()
     * @param \StructType\CoordinateSystemAxisPropertyType $axis
     * @param string $aggregationType
     */
    public function __construct(\StructType\CoordinateSystemAxisPropertyType $axis = null, $aggregationType = null)
    {
        $this
            ->setAxis($axis)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get axis value
     * @return \StructType\CoordinateSystemAxisPropertyType|null
     */
    public function getAxis()
    {
        return $this->axis;
    }
    /**
     * Set axis value
     * @param \StructType\CoordinateSystemAxisPropertyType $axis
     * @return \StructType\AbstractCoordinateSystemType
     */
    public function setAxis(\StructType\CoordinateSystemAxisPropertyType $axis = null)
    {
        $this->axis = $axis;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\AbstractCoordinateSystemType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
