<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for Codeliste.Signatur EnumType
 * @subpackage Enumerations
 */
class Codeliste_Signatur extends AbstractStructEnumBase
{
    /**
     * Constant for value '001'
     * Meta information extracted from the WSDL
     * - documentation: Es wird keine Signatur benötigt.
     * @return string '001'
     */
    const VALUE_001 = '001';
    /**
     * Constant for value '004'
     * Meta information extracted from the WSDL
     * - documentation: Handschriftliche, eigenhändige Namenszeichnung auf Schriftstücken durch eine natürliche Person mit mindestens dem Familiennamen. Nicht elektronisch.
     * @return string '004'
     */
    const VALUE_004 = '004';
    /**
     * Constant for value '101'
     * Meta information extracted from the WSDL
     * - documentation: An eine einfache elektronische Signatur werden keine besonderen Anforderungen gestellt. So gilt z.B. auch die Angabe des Urhebers oder Absenders ohne digitale Signatur als „einfache“ Signatur. (Quelle: wikipedia.de)
     * @return string '101'
     */
    const VALUE_101 = '101';
    /**
     * Constant for value '102'
     * Meta information extracted from the WSDL
     * - documentation: Für eine fortgeschrittene elektronischen Signatur übernimmt § 2 Nr. 2 SigG im Wesentlichen die Definition der Richtlinie: Eine fortgeschrittene Signatur muss mit einem einmaligen – praktisch also geheimen – Signaturschlüssel,
     * der dem Signaturersteller während der Signaturerstellung zur Verfügung stehen muss, und mit Mitteln, die unter seiner alleinigen Kontrolle stehen, erstellt worden sein. Zusätzlich muss der Signaturersteller bei Bedarf identifizierbar sein. Dies
     * erfolgt entweder über den dem Signaturersteller zugewiesenen Prüfschlüssel oder gegebenenfalls mittels während der Signaturerstellung erfasster biometrischer Unterschriften. (Quelle: wikipedia.de)
     * @return string '102'
     */
    const VALUE_102 = '102';
    /**
     * Constant for value '103'
     * Meta information extracted from the WSDL
     * - documentation: Nur Dokumente mit einer qualifizierten elektronischen Signatur gemäß § 2 Nr. 3 SigG können als elektronische Form eine per Gesetz geforderte Schriftform auf Papier ersetzen, vgl. § 126a BGB. In Übereinstimmung mit der
     * europäischen Richtlinie ist eine qualifizierte elektronische Signatur eine fortgeschrittene elektronische Signatur, die auf einem zum Zeitpunkt ihrer Erzeugung gültigen qualifizierten Zertifikat beruht und mit einer sicheren
     * Signaturerstellungseinheit (SSEE) erstellt wurde. Der Signaturschlüssel darf dabei ausschließlich in der SSEE gespeichert und angewendet werden, und die Übereinstimmung der SSEE mit den Vorgaben des Signaturgesetzes muss durch eine anerkannte
     * Stelle geprüft und bestätigt werden. Dagegen ist auch für qualifizierte elektronische Signaturen eine Prüfung und Bestätigung der Signaturanwendungskomponente, welche Signatursoftware, Treiber und Chipkartenleser umfasst, nicht zwingend
     * vorgeschrieben, jedoch ist mindestens eine Herstellererklärung nötig, in der der jeweilige Hersteller die Konformität der Komponente zum SigG und zur SigV gemäß § 17 SigG bestätigt. Eine solche Herstellererklärung wird später von der
     * Bundesnetzagentur im Bundesanzeiger veröffentlicht[8], ist aber bereits mit der Einreichung bei der Bundesnetzagentur genügend. (Quelle: wikipedia.de)
     * @return string '103'
     */
    const VALUE_103 = '103';
    /**
     * Constant for value '104'
     * Meta information extracted from the WSDL
     * - documentation: Zusätzlich wird bei qualifizierten elektronischen Signaturen unterschieden, von welchem Anbieter die Zertifikate ausgestellt und die Signaturschlüssel erzeugt werden. Dabei wird zwischen nicht-akkreditierten Anbietern und Anbietern
     * mit Akkreditierung durch die Bundesnetzagentur unterschieden. Laut Signaturgesetz muss jeder Anbieter von Zertifikaten für qualifizierte elektronische Signaturen bestimmte Anforderungen bezüglich des von ihm betriebenen Rechenzentrums erfüllen.
     * Der Anbieter kann sich bescheinigen lassen, dass sein Rechenzentrum den höchsten Sicherheitsanforderungen genügt. Dem geht eine Prüfung durch eine anerkannte Bestätigungsstelle (das Bundesamt für Sicherheit in der Informationstechnik (BSI) oder
     * eine private Bestätigungsstelle) voraus. Stellt diese fest, dass die Sicherheitsanforderungen durch den Anbieter bzw. den Betreiber des Rechenzentrums (wird in diesem Rahmen auch als Trust Center bezeichnet) erfüllt sind, bescheinigt die
     * Bundesnetzagentur dessen Sicherheit. Der Betreiber des Rechenzentrums darf sich nun als akkreditiert bezeichnen und erhält für seine Zertifizierungsdienste qualifizierte Zertifikate von der Zertifizierungsstelle der Bundesnetzagentur, die in
     * Deutschland die Wurzelinstanz (Root CA) in der Public-Key-Infrastruktur (PKI) für qualifizierte Zertifikate darstellt. (Quelle: wikipedia.de)
     * @return string '104'
     */
    const VALUE_104 = '104';
    /**
     * Return allowed values
     * @uses self::VALUE_001
     * @uses self::VALUE_004
     * @uses self::VALUE_101
     * @uses self::VALUE_102
     * @uses self::VALUE_103
     * @uses self::VALUE_104
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_001,
            self::VALUE_004,
            self::VALUE_101,
            self::VALUE_102,
            self::VALUE_103,
            self::VALUE_104,
        );
    }
}
