<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for Codeliste.Leistungsklasse EnumType
 * @subpackage Enumerations
 */
class Codeliste_Leistungsklasse extends AbstractStructEnumBase
{
    /**
     * Constant for value 'L'
     * Meta information extracted from the WSDL
     * - documentation: Leistungen im Allgemeinen (ohne spezielle Ausprägung nach Leika).
     * @return string 'L'
     */
    const VALUE_L = 'L';
    /**
     * Constant for value 'LO'
     * Meta information extracted from the WSDL
     * - documentation: Leistungsobjekt nach Leika, z.B. "Personalausweis".
     * @return string 'LO'
     */
    const VALUE_LO = 'LO';
    /**
     * Constant for value 'LOV'
     * Meta information extracted from the WSDL
     * - documentation: Leistungsobjekt mit Verrichtung nach Leika, z.B. "Personalausweis Ausstellung".
     * @return string 'LOV'
     */
    const VALUE_LOV = 'LOV';
    /**
     * Constant for value 'LOVD'
     * Meta information extracted from the WSDL
     * - documentation: Leistungsobjekt mit Verrichtung und Verrichtungsdetail nach Leika, z.B."Personalausweis Ausstellung erstmalig".
     * @return string 'LOVD'
     */
    const VALUE_LOVD = 'LOVD';
    /**
     * Return allowed values
     * @uses self::VALUE_L
     * @uses self::VALUE_LO
     * @uses self::VALUE_LOV
     * @uses self::VALUE_LOVD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_L,
            self::VALUE_LO,
            self::VALUE_LOV,
            self::VALUE_LOVD,
        );
    }
}
