<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Zeitserie StructType
 * Meta information extracted from the WSDL
 * - documentation: Dieser Datentyp repräsentiert eine Regel zur Positionierung einer Zeitserie, z.B. für eine Öffnungszeit. Im Objekt lassen sich eine Position und ein Typ definieren (Regel). Dazu werden eine Beginn- und eine Endzeit angegeben.
 * Ergänzt werden kann der Zeitraum durch einen Zusatztext. Zeitserie repräsentiert innerhalb der gesamten regulären Zeitserien ein Zeitfenster.
 * @subpackage Structs
 */
class Zeitserie extends AbstractStructBase
{
    /**
     * The tagesposition
     * Meta information extracted from the WSDL
     * - documentation: Tagesposition definiert die Stellung des Zeitelementes im Kontext des Tagestyp. Tagesposition kann dabei absolute (15.), relative (letzter) oder mehrfache (jeden) Positionen definieren.
     * @var \StructType\Code_Tagesposition
     */
    public $tagesposition;
    /**
     * The tagestyp
     * Meta information extracted from the WSDL
     * - documentation: Tagestyp definiert die Art der Zeitserie. Typischerweise sind dies bestimmte Wochentage oder eine Menge von Tagen. Die Kombination von Tagesposition und Tagestyp wird in verschiedenen Zeitrahmen definiert. Jeden Montag betrifft
     * beispielsweise jede Woche am Montag. Jeden Arbeitstag betrifft alle aufeinanderfolgenden Tage an denen gearbeitet wird. 15. Tag betrifft jeweils den 15. Tag eines Monats. Der Kontext wird somit immer in der nächst höheren Zeitebene gesetzt.
     * Definitionen für einzelne Tage im Jahr erfolgen aktuell als abweichende Oeffnungszeit, da die Zeitspanne hierfür zu groß ist.
     * @var \StructType\Code_Tagestyp
     */
    public $tagestyp;
    /**
     * The beginn
     * Meta information extracted from the WSDL
     * - documentation: Beginn ist die Uhrzeit zu der das Zeitfenster in der Kombination von Tagesposition und Tagestyp beginnt.
     * @var string
     */
    public $beginn;
    /**
     * The ende
     * Meta information extracted from the WSDL
     * - documentation: Ende ist die Uhrzeit zu der das Zeitfenster in der Kombination von Tagesposition und Tagestyp endet.
     * @var string
     */
    public $ende;
    /**
     * The zusatz
     * Meta information extracted from the WSDL
     * - documentation: Zusatz ist ein ergänzender Text für das spezifische Zeitfenster der Öffnungszeit. Dies betrifft insbesondere Einschränkungen wie z.B. nur für alleinerziehende Mütter.
     * - minOccurs: 0
     * @var \StructType\String_Localized
     */
    public $zusatz;
    /**
     * Constructor method for Zeitserie
     * @uses Zeitserie::setTagesposition()
     * @uses Zeitserie::setTagestyp()
     * @uses Zeitserie::setBeginn()
     * @uses Zeitserie::setEnde()
     * @uses Zeitserie::setZusatz()
     * @param \StructType\Code_Tagesposition $tagesposition
     * @param \StructType\Code_Tagestyp $tagestyp
     * @param string $beginn
     * @param string $ende
     * @param \StructType\String_Localized $zusatz
     */
    public function __construct(\StructType\Code_Tagesposition $tagesposition = null, \StructType\Code_Tagestyp $tagestyp = null, $beginn = null, $ende = null, \StructType\String_Localized $zusatz = null)
    {
        $this
            ->setTagesposition($tagesposition)
            ->setTagestyp($tagestyp)
            ->setBeginn($beginn)
            ->setEnde($ende)
            ->setZusatz($zusatz);
    }
    /**
     * Get tagesposition value
     * @return \StructType\Code_Tagesposition|null
     */
    public function getTagesposition()
    {
        return $this->tagesposition;
    }
    /**
     * Set tagesposition value
     * @param \StructType\Code_Tagesposition $tagesposition
     * @return \StructType\Zeitserie
     */
    public function setTagesposition(\StructType\Code_Tagesposition $tagesposition = null)
    {
        $this->tagesposition = $tagesposition;
        return $this;
    }
    /**
     * Get tagestyp value
     * @return \StructType\Code_Tagestyp|null
     */
    public function getTagestyp()
    {
        return $this->tagestyp;
    }
    /**
     * Set tagestyp value
     * @param \StructType\Code_Tagestyp $tagestyp
     * @return \StructType\Zeitserie
     */
    public function setTagestyp(\StructType\Code_Tagestyp $tagestyp = null)
    {
        $this->tagestyp = $tagestyp;
        return $this;
    }
    /**
     * Get beginn value
     * @return string|null
     */
    public function getBeginn()
    {
        return $this->beginn;
    }
    /**
     * Set beginn value
     * @param string $beginn
     * @return \StructType\Zeitserie
     */
    public function setBeginn($beginn = null)
    {
        // validation for constraint: string
        if (!is_null($beginn) && !is_string($beginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginn, true), gettype($beginn)), __LINE__);
        }
        $this->beginn = $beginn;
        return $this;
    }
    /**
     * Get ende value
     * @return string|null
     */
    public function getEnde()
    {
        return $this->ende;
    }
    /**
     * Set ende value
     * @param string $ende
     * @return \StructType\Zeitserie
     */
    public function setEnde($ende = null)
    {
        // validation for constraint: string
        if (!is_null($ende) && !is_string($ende)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ende, true), gettype($ende)), __LINE__);
        }
        $this->ende = $ende;
        return $this;
    }
    /**
     * Get zusatz value
     * @return \StructType\String_Localized|null
     */
    public function getZusatz()
    {
        return $this->zusatz;
    }
    /**
     * Set zusatz value
     * @param \StructType\String_Localized $zusatz
     * @return \StructType\Zeitserie
     */
    public function setZusatz(\StructType\String_Localized $zusatz = null)
    {
        $this->zusatz = $zusatz;
        return $this;
    }
}
