<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValueArrayPropertyType StructType
 * @subpackage Structs
 */
class ValueArrayPropertyType extends AbstractStructBase
{
    /**
     * The AbstractValue
     * @var mixed
     */
    public $AbstractValue;
    /**
     * The AbstractGeometry
     * @var \StructType\AbstractGeometryType
     */
    public $AbstractGeometry;
    /**
     * The AbstractTimeObject
     * @var \StructType\AbstractTimeObjectType
     */
    public $AbstractTimeObject;
    /**
     * The Null
     * @var string
     */
    public $Null;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for ValueArrayPropertyType
     * @uses ValueArrayPropertyType::setAbstractValue()
     * @uses ValueArrayPropertyType::setAbstractGeometry()
     * @uses ValueArrayPropertyType::setAbstractTimeObject()
     * @uses ValueArrayPropertyType::setNull()
     * @uses ValueArrayPropertyType::setOwns()
     * @param mixed $abstractValue
     * @param \StructType\AbstractGeometryType $abstractGeometry
     * @param \StructType\AbstractTimeObjectType $abstractTimeObject
     * @param string $null
     * @param bool $owns
     */
    public function __construct($abstractValue = null, \StructType\AbstractGeometryType $abstractGeometry = null, \StructType\AbstractTimeObjectType $abstractTimeObject = null, $null = null, $owns = null)
    {
        $this
            ->setAbstractValue($abstractValue)
            ->setAbstractGeometry($abstractGeometry)
            ->setAbstractTimeObject($abstractTimeObject)
            ->setNull($null)
            ->setOwns($owns);
    }
    /**
     * Get AbstractValue value
     * @return mixed|null
     */
    public function getAbstractValue()
    {
        return $this->AbstractValue;
    }
    /**
     * Set AbstractValue value
     * @param mixed $abstractValue
     * @return \StructType\ValueArrayPropertyType
     */
    public function setAbstractValue($abstractValue = null)
    {
        $this->AbstractValue = $abstractValue;
        return $this;
    }
    /**
     * Get AbstractGeometry value
     * @return \StructType\AbstractGeometryType|null
     */
    public function getAbstractGeometry()
    {
        return $this->AbstractGeometry;
    }
    /**
     * Set AbstractGeometry value
     * @param \StructType\AbstractGeometryType $abstractGeometry
     * @return \StructType\ValueArrayPropertyType
     */
    public function setAbstractGeometry(\StructType\AbstractGeometryType $abstractGeometry = null)
    {
        $this->AbstractGeometry = $abstractGeometry;
        return $this;
    }
    /**
     * Get AbstractTimeObject value
     * @return \StructType\AbstractTimeObjectType|null
     */
    public function getAbstractTimeObject()
    {
        return $this->AbstractTimeObject;
    }
    /**
     * Set AbstractTimeObject value
     * @param \StructType\AbstractTimeObjectType $abstractTimeObject
     * @return \StructType\ValueArrayPropertyType
     */
    public function setAbstractTimeObject(\StructType\AbstractTimeObjectType $abstractTimeObject = null)
    {
        $this->AbstractTimeObject = $abstractTimeObject;
        return $this;
    }
    /**
     * Get Null value
     * @return string|null
     */
    public function getNull()
    {
        return $this->Null;
    }
    /**
     * Set Null value
     * @param string $null
     * @return \StructType\ValueArrayPropertyType
     */
    public function setNull($null = null)
    {
        // validation for constraint: string
        if (!is_null($null) && !is_string($null)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($null, true), gettype($null)), __LINE__);
        }
        $this->Null = $null;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\ValueArrayPropertyType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
