<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for URL_PropertyType StructType
 * @subpackage Structs
 */
class URL_PropertyType extends AbstractStructBase
{
    /**
     * The URL
     * @var string
     */
    public $URL;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for URL_PropertyType
     * @uses URL_PropertyType::setURL()
     * @uses URL_PropertyType::setNilReason()
     * @param string $uRL
     * @param string $nilReason
     */
    public function __construct($uRL = null, $nilReason = null)
    {
        $this
            ->setURL($uRL)
            ->setNilReason($nilReason);
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\URL_PropertyType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\URL_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
