<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransformationType StructType
 * @subpackage Structs
 */
class TransformationType extends AbstractStructBase
{
    /**
     * The method
     * @var \StructType\OperationMethodPropertyType
     */
    public $method;
    /**
     * The parameterValue
     * @var \StructType\AbstractGeneralParameterValuePropertyType
     */
    public $parameterValue;
    /**
     * Constructor method for TransformationType
     * @uses TransformationType::setMethod()
     * @uses TransformationType::setParameterValue()
     * @param \StructType\OperationMethodPropertyType $method
     * @param \StructType\AbstractGeneralParameterValuePropertyType $parameterValue
     */
    public function __construct(\StructType\OperationMethodPropertyType $method = null, \StructType\AbstractGeneralParameterValuePropertyType $parameterValue = null)
    {
        $this
            ->setMethod($method)
            ->setParameterValue($parameterValue);
    }
    /**
     * Get method value
     * @return \StructType\OperationMethodPropertyType|null
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param \StructType\OperationMethodPropertyType $method
     * @return \StructType\TransformationType
     */
    public function setMethod(\StructType\OperationMethodPropertyType $method = null)
    {
        $this->method = $method;
        return $this;
    }
    /**
     * Get parameterValue value
     * @return \StructType\AbstractGeneralParameterValuePropertyType|null
     */
    public function getParameterValue()
    {
        return $this->parameterValue;
    }
    /**
     * Set parameterValue value
     * @param \StructType\AbstractGeneralParameterValuePropertyType $parameterValue
     * @return \StructType\TransformationType
     */
    public function setParameterValue(\StructType\AbstractGeneralParameterValuePropertyType $parameterValue = null)
    {
        $this->parameterValue = $parameterValue;
        return $this;
    }
}
