<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopoVolumeType StructType
 * @subpackage Structs
 */
class TopoVolumeType extends AbstractStructBase
{
    /**
     * The directedTopoSolid
     * @var \StructType\DirectedTopoSolidPropertyType
     */
    public $directedTopoSolid;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for TopoVolumeType
     * @uses TopoVolumeType::setDirectedTopoSolid()
     * @uses TopoVolumeType::setAggregationType()
     * @param \StructType\DirectedTopoSolidPropertyType $directedTopoSolid
     * @param string $aggregationType
     */
    public function __construct(\StructType\DirectedTopoSolidPropertyType $directedTopoSolid = null, $aggregationType = null)
    {
        $this
            ->setDirectedTopoSolid($directedTopoSolid)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get directedTopoSolid value
     * @return \StructType\DirectedTopoSolidPropertyType|null
     */
    public function getDirectedTopoSolid()
    {
        return $this->directedTopoSolid;
    }
    /**
     * Set directedTopoSolid value
     * @param \StructType\DirectedTopoSolidPropertyType $directedTopoSolid
     * @return \StructType\TopoVolumeType
     */
    public function setDirectedTopoSolid(\StructType\DirectedTopoSolidPropertyType $directedTopoSolid = null)
    {
        $this->directedTopoSolid = $directedTopoSolid;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\TopoVolumeType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
