<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopoSolidType StructType
 * @subpackage Structs
 */
class TopoSolidType extends AbstractStructBase
{
    /**
     * The isolated
     * @var \StructType\NodeOrEdgePropertyType
     */
    public $isolated;
    /**
     * The directedFace
     * @var \StructType\DirectedFacePropertyType
     */
    public $directedFace;
    /**
     * The solidProperty
     * @var \StructType\SolidPropertyType
     */
    public $solidProperty;
    /**
     * The universal
     * @var bool
     */
    public $universal;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for TopoSolidType
     * @uses TopoSolidType::setIsolated()
     * @uses TopoSolidType::setDirectedFace()
     * @uses TopoSolidType::setSolidProperty()
     * @uses TopoSolidType::setUniversal()
     * @uses TopoSolidType::setAggregationType()
     * @param \StructType\NodeOrEdgePropertyType $isolated
     * @param \StructType\DirectedFacePropertyType $directedFace
     * @param \StructType\SolidPropertyType $solidProperty
     * @param bool $universal
     * @param string $aggregationType
     */
    public function __construct(\StructType\NodeOrEdgePropertyType $isolated = null, \StructType\DirectedFacePropertyType $directedFace = null, \StructType\SolidPropertyType $solidProperty = null, $universal = null, $aggregationType = null)
    {
        $this
            ->setIsolated($isolated)
            ->setDirectedFace($directedFace)
            ->setSolidProperty($solidProperty)
            ->setUniversal($universal)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get isolated value
     * @return \StructType\NodeOrEdgePropertyType|null
     */
    public function getIsolated()
    {
        return $this->isolated;
    }
    /**
     * Set isolated value
     * @param \StructType\NodeOrEdgePropertyType $isolated
     * @return \StructType\TopoSolidType
     */
    public function setIsolated(\StructType\NodeOrEdgePropertyType $isolated = null)
    {
        $this->isolated = $isolated;
        return $this;
    }
    /**
     * Get directedFace value
     * @return \StructType\DirectedFacePropertyType|null
     */
    public function getDirectedFace()
    {
        return $this->directedFace;
    }
    /**
     * Set directedFace value
     * @param \StructType\DirectedFacePropertyType $directedFace
     * @return \StructType\TopoSolidType
     */
    public function setDirectedFace(\StructType\DirectedFacePropertyType $directedFace = null)
    {
        $this->directedFace = $directedFace;
        return $this;
    }
    /**
     * Get solidProperty value
     * @return \StructType\SolidPropertyType|null
     */
    public function getSolidProperty()
    {
        return $this->solidProperty;
    }
    /**
     * Set solidProperty value
     * @param \StructType\SolidPropertyType $solidProperty
     * @return \StructType\TopoSolidType
     */
    public function setSolidProperty(\StructType\SolidPropertyType $solidProperty = null)
    {
        $this->solidProperty = $solidProperty;
        return $this;
    }
    /**
     * Get universal value
     * @return bool|null
     */
    public function getUniversal()
    {
        return $this->universal;
    }
    /**
     * Set universal value
     * @param bool $universal
     * @return \StructType\TopoSolidType
     */
    public function setUniversal($universal = null)
    {
        // validation for constraint: boolean
        if (!is_null($universal) && !is_bool($universal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($universal, true), gettype($universal)), __LINE__);
        }
        $this->universal = $universal;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\TopoSolidType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
