<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopoPointPropertyType StructType
 * @subpackage Structs
 */
class TopoPointPropertyType extends AbstractStructBase
{
    /**
     * The TopoPoint
     * @var \StructType\TopoPointType
     */
    public $TopoPoint;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for TopoPointPropertyType
     * @uses TopoPointPropertyType::setTopoPoint()
     * @uses TopoPointPropertyType::setOwns()
     * @param \StructType\TopoPointType $topoPoint
     * @param bool $owns
     */
    public function __construct(\StructType\TopoPointType $topoPoint = null, $owns = null)
    {
        $this
            ->setTopoPoint($topoPoint)
            ->setOwns($owns);
    }
    /**
     * Get TopoPoint value
     * @return \StructType\TopoPointType|null
     */
    public function getTopoPoint()
    {
        return $this->TopoPoint;
    }
    /**
     * Set TopoPoint value
     * @param \StructType\TopoPointType $topoPoint
     * @return \StructType\TopoPointPropertyType
     */
    public function setTopoPoint(\StructType\TopoPointType $topoPoint = null)
    {
        $this->TopoPoint = $topoPoint;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\TopoPointPropertyType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
